/*
 * Decompiled with CFR 0.152.
 */
package fr.lip6.move.gal.structural.hlpn;

import fr.lip6.move.gal.structural.hlpn.HLPlace;
import fr.lip6.move.gal.structural.hlpn.Sort;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.TreeSet;

public class Partition {
    private int[] partition;
    private int nbSubs;

    public Partition(int size) {
        this.partition = new int[size];
        this.nbSubs = 1;
    }

    public Partition(int size, List<Integer> sub) {
        this.partition = new int[size];
        if (sub.size() == size) {
            this.nbSubs = 1;
        } else {
            this.nbSubs = 2;
            for (int i : sub) {
                this.partition[i] = 1;
            }
        }
    }

    public Partition(Collection<List<Integer>> parts) {
        int size = parts.stream().mapToInt(List::size).sum();
        this.partition = new int[size];
        int i = 0;
        for (List<Integer> l : parts) {
            if (i != 0) {
                for (Integer elt : l) {
                    this.partition[elt.intValue()] = i;
                }
            }
            ++i;
        }
        this.nbSubs = parts.size();
    }

    public int getNbSubs() {
        return this.nbSubs;
    }

    public static Partition refine(Partition p1, Partition p2) {
        if (p1.partition.length != p2.partition.length) {
            throw new IllegalArgumentException("Partitions need to correspond to the same superset.");
        }
        if (p1.nbSubs == 1) {
            return p2;
        }
        if (p2.nbSubs == 1) {
            return p1;
        }
        Partition p = new Partition(p1.partition.length);
        TreeSet<Integer> indexes = new TreeSet<Integer>();
        int i = 0;
        while (i < p.partition.length) {
            int ip1 = p1.partition[i];
            int ip2 = p2.partition[i];
            int ip = ip1 * p2.nbSubs + ip2;
            indexes.add(ip);
            p.partition[i] = ip;
            ++i;
        }
        p.nbSubs = indexes.size();
        HashMap<Integer, Integer> perm = new HashMap<Integer, Integer>();
        int id = 0;
        for (Integer e : indexes) {
            perm.put(e, id++);
        }
        int i2 = 0;
        while (i2 < p.partition.length) {
            p.partition[i2] = (Integer)perm.get(p.partition[i2]);
            ++i2;
        }
        return p;
    }

    public List<Integer> covers(List<Integer> list) {
        TreeSet<Integer> set = new TreeSet<Integer>();
        for (Integer elt : list) {
            set.add(this.partition[elt]);
        }
        return new ArrayList<Integer>(set);
    }

    public String toString() {
        return "Partition [nbSubs=" + this.nbSubs + ", partition=" + Arrays.toString(this.partition) + "]\n";
    }

    public int size() {
        return this.partition.length;
    }

    public static int sumprod(int[] cur, int[] multipliers) {
        int res = 0;
        int i = 0;
        int ie = cur.length;
        while (i < ie) {
            res += cur[i] * multipliers[i];
            ++i;
        }
        return res;
    }

    public int[] rewriteMarking(HLPlace place, int sortindex) {
        int[] initial = place.getInitial();
        int[] res = new int[initial.length / this.size() * this.getNbSubs()];
        List<Sort> sort = place.getSort();
        int[] multipliers = new int[sort.size()];
        multipliers[sort.size() - 1] = 1;
        int i = sort.size() - 2;
        while (i >= 0) {
            multipliers[i] = i + 1 == sortindex ? multipliers[i + 1] * this.nbSubs : multipliers[i + 1] * sort.get(i + 1).size();
            --i;
        }
        int[] cur = new int[place.getSort().size()];
        int i2 = 0;
        while (i2 < initial.length) {
            if (initial[i2] > 0) {
                int old = cur[sortindex];
                cur[sortindex] = this.partition[cur[sortindex]];
                int target = Partition.sumprod(cur, multipliers);
                if (target >= res.length) {
                    System.out.println("WTF ??");
                }
                int n = target;
                res[n] = res[n] + initial[i2];
                cur[sortindex] = old;
            }
            int j = cur.length - 1;
            while (j >= 0) {
                if (cur[j] != place.getSort().get(j).size() - 1) {
                    int n = j;
                    cur[n] = cur[n] + 1;
                    break;
                }
                cur[j] = 0;
                --j;
            }
            ++i2;
        }
        return res;
    }

    public int getImage(int target) {
        return this.partition[target];
    }
}

