/*
 * Decompiled with CFR 0.152.
 */
package fr.lip6.move.gal.structural.hlpn;

import android.util.SparseIntArray;
import fr.lip6.move.gal.structural.PetriNet;
import fr.lip6.move.gal.structural.Property;
import fr.lip6.move.gal.structural.PropertyType;
import fr.lip6.move.gal.structural.SparsePetriNet;
import fr.lip6.move.gal.structural.StructuralReduction;
import fr.lip6.move.gal.structural.expr.ArrayVarRef;
import fr.lip6.move.gal.structural.expr.BinOp;
import fr.lip6.move.gal.structural.expr.Expression;
import fr.lip6.move.gal.structural.expr.NaryOp;
import fr.lip6.move.gal.structural.expr.Op;
import fr.lip6.move.gal.structural.expr.Param;
import fr.lip6.move.gal.structural.expr.ParamRef;
import fr.lip6.move.gal.structural.expr.Simplifier;
import fr.lip6.move.gal.structural.hlpn.HLArc;
import fr.lip6.move.gal.structural.hlpn.HLPlace;
import fr.lip6.move.gal.structural.hlpn.HLTrans;
import fr.lip6.move.gal.structural.hlpn.Sort;
import fr.lip6.move.gal.structural.hlpn.SymmetricUnfolder;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import java.util.stream.Collectors;

public class SparseHLPetriNet
extends PetriNet {
    private static final int DEBUG = 0;
    private List<Sort> sorts = new ArrayList<Sort>();
    private List<HLPlace> places = new ArrayList<HLPlace>();
    private List<HLTrans> transitions = new ArrayList<HLTrans>();
    int placeCount = 0;

    public int addTransition(String tname, List<Param> params, Expression guard) {
        this.transitions.add(new HLTrans(tname, params, guard));
        return this.transitions.size() - 1;
    }

    public int addPlace(String pname, int[] init, List<Sort> sort) {
        int index = this.placeCount;
        this.places.add(new HLPlace(pname, index, init, sort));
        this.placeCount += init.length;
        return this.places.size() - 1;
    }

    public void addSort(Sort sort) {
        this.sorts.add(sort);
    }

    public void addPreArc(int p, int t, List<Expression> func, int val) {
        this.transitions.get(t).getPre().add(new HLArc(p, val, func));
    }

    public void addPostArc(int p, int t, List<Expression> func, int val) {
        this.transitions.get(t).getPost().add(new HLArc(p, val, func));
    }

    public Sort findSort(String name) {
        for (Sort s : this.sorts) {
            if (!s.getName().equals(name)) continue;
            return s;
        }
        System.err.println("Warning : Sort " + name + " not registered in HL net. Existing sorts :" + String.valueOf(this.sorts));
        return null;
    }

    @Override
    public int getPlaceCount() {
        return this.placeCount;
    }

    public List<HLPlace> getPlaces() {
        return this.places;
    }

    public List<HLTrans> getTransitions() {
        return this.transitions;
    }

    @Override
    public int getTransitionCount() {
        return this.transitions.size();
    }

    @Override
    public int getTransitionIndex(String name) {
        int i = 0;
        int ie = this.transitions.size();
        while (i < ie) {
            if (this.transitions.get(i).getName().equals(name)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    @Override
    public int getPlaceIndex(String name) {
        int i = 0;
        int ie = this.places.size();
        while (i < ie) {
            if (this.places.get(i).getName().equals(name)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public String toString() {
        return "SparseHLPetriNet\n[places=" + String.valueOf(this.places) + ",\n transitions=" + String.valueOf(this.transitions) + ",\n getName()=" + this.getName() + ",\n getProperties()=" + String.valueOf(this.getProperties()) + "]";
    }

    public SparsePetriNet skeleton() {
        long time = System.currentTimeMillis();
        SparsePetriNet spn = new SparsePetriNet();
        spn.setName(this.getName() + "_skel");
        spn.setSkeleton(true);
        for (HLPlace p : this.places) {
            spn.addPlace(p.getName(), Arrays.stream(p.getInitial()).sum());
        }
        for (HLTrans t : this.transitions) {
            spn.addTransition(t.getName());
            SparseIntArray pt = this.computeCardinality(t.getPre());
            int i = 0;
            int ie = pt.size();
            while (i < ie) {
                spn.addPreArc(pt.keyAt(i), spn.getTransitionCount() - 1, pt.valueAt(i));
                ++i;
            }
            SparseIntArray tp = this.computeCardinality(t.getPost());
            int i2 = 0;
            int ie2 = tp.size();
            while (i2 < ie2) {
                spn.addPostArc(tp.keyAt(i2), spn.getTransitionCount() - 1, tp.valueAt(i2));
                ++i2;
            }
        }
        Logger.getLogger("fr.lip6.move.gal").info("Built PT skeleton of HLPN with " + spn.getPlaceCount() + " places and " + spn.getTransitionCount() + " transitions " + spn.getArcCount() + " arcs in " + (System.currentTimeMillis() - time) + " ms.");
        time = System.currentTimeMillis();
        int removed = 0;
        for (Property p : this.getProperties()) {
            if (!(p.getType() != PropertyType.CTL && p.getType() != PropertyType.LTL || this.hasNoGuardedEnablingCombinations(p))) {
                ++removed;
                continue;
            }
            spn.getProperties().add(new Property(this.bindSkeletonColors(p.getBody()), p.getType(), p.getName()));
        }
        Logger.getLogger("fr.lip6.move.gal").info("Skeletonized " + spn.getProperties().size() + " HLPN properties in " + (System.currentTimeMillis() - time) + " ms." + (String)(removed > 0 ? " Removed " + removed + " properties that had guard overlaps." : ""));
        return spn;
    }

    private SparseIntArray computeCardinality(List<HLArc> pre) {
        SparseIntArray pt = new SparseIntArray();
        for (HLArc arc : pre) {
            int pind = arc.getPlace();
            int val = pt.get(pind) + arc.getCoeff();
            pt.put(pind, val);
        }
        return pt;
    }

    public SparsePetriNet unfold(StructuralReduction.ReductionType rt) {
        ArrayList<List<Integer>> enablings = new ArrayList<List<Integer>>(this.transitions.size());
        return this.unfold(enablings, rt);
    }

    public List<Sort> getSorts() {
        return this.sorts;
    }

    public SparsePetriNet unfold(List<List<Integer>> enablings, StructuralReduction.ReductionType rt) {
        long time = System.currentTimeMillis();
        if (rt != StructuralReduction.ReductionType.STATESPACE) {
            SymmetricUnfolder.testSymmetryConditions(this);
        }
        SparsePetriNet spn = new SparsePetriNet();
        spn.setName(this.getName() + "_unf");
        StringBuilder sb = new StringBuilder();
        for (HLPlace p : this.places) {
            String hlname = p.getName();
            sb.append(hlname);
            int ie = p.getInitial().length;
            if (ie != 1) {
                sb.append('_');
            }
            int i = 0;
            while (i < ie) {
                if (ie != 1) {
                    sb.setLength(hlname.length() + 1);
                    sb.append(i);
                }
                spn.addPlace(sb.toString(), p.getInitial()[i]);
                ++i;
            }
            sb.setLength(0);
        }
        for (HLTrans t : this.transitions) {
            ArrayDeque<HLTrans> todo = new ArrayDeque<HLTrans>();
            this.fuseEqualParameters(t);
            t.getParams().sort((a, b) -> Integer.compare(a.size(), b.size()));
            todo.add(t);
            ArrayList<Integer> done = new ArrayList<Integer>();
            while (!todo.isEmpty()) {
                HLTrans bt = (HLTrans)todo.poll();
                if (bt.getParams().isEmpty()) {
                    int tind = this.transformHLtoPT(bt, spn);
                    if (tind < 0) continue;
                    done.add(tind);
                    continue;
                }
                ArrayList<Param> pcopy = new ArrayList<Param>(bt.getParams().subList(1, bt.getParams().size()));
                Param cur = bt.getParams().get(0);
                int val = 0;
                while (val < cur.size()) {
                    Expression guard = SparseHLPetriNet.bind(cur, val, bt.getGuard());
                    if (guard.getOp() != Op.BOOLCONST || guard.getValue() != 0) {
                        int pind;
                        int value;
                        List<Expression> r;
                        HLTrans tcopy = new HLTrans(bt.getName() + cur.getName() + val, pcopy, guard);
                        boolean skip = false;
                        int fval = val;
                        for (HLArc arc : bt.getPre()) {
                            r = arc.getCfunc().stream().map(e -> SparseHLPetriNet.bind(cur, fval, e)).collect(Collectors.toList());
                            value = arc.getCoeff();
                            pind = arc.getPlace();
                            if (this.places.get(pind).isConstant() && r.stream().allMatch(e -> e.getOp() == Op.CONST)) {
                                if (this.places.get(pind).getInitial()[this.places.get(pind).resolve(r)] >= value) continue;
                                skip = true;
                                break;
                            }
                            tcopy.getPre().add(new HLArc(pind, value, r));
                        }
                        if (!skip) {
                            for (HLArc arc : bt.getPost()) {
                                r = arc.getCfunc().stream().map(e -> SparseHLPetriNet.bind(cur, fval, e)).collect(Collectors.toList());
                                value = arc.getCoeff();
                                pind = arc.getPlace();
                                if (this.places.get(pind).isConstant() && r.stream().allMatch(e -> e.getOp() == Op.CONST)) continue;
                                tcopy.getPost().add(new HLArc(pind, value, r));
                            }
                            todo.add(tcopy);
                        }
                    }
                    ++val;
                }
            }
            enablings.add(done);
        }
        Logger.getLogger("fr.lip6.move.gal").info("Unfolded HLPN to a Petri net with " + spn.getPlaceCount() + " places and " + spn.getTransitionCount() + " transitions " + (spn.getFlowPT().getColumns().stream().mapToInt(c -> c.size()).sum() + spn.getFlowTP().getColumns().stream().mapToInt(c -> c.size()).sum()) + " arcs in " + (System.currentTimeMillis() - time) + " ms.");
        time = System.currentTimeMillis();
        for (Property p : this.getProperties()) {
            spn.getProperties().add(new Property(this.bindColors(p.getBody(), enablings), p.getType(), p.getName()));
        }
        Logger.getLogger("fr.lip6.move.gal").info("Unfolded " + spn.getProperties().size() + " HLPN properties in " + (System.currentTimeMillis() - time) + " ms.");
        return spn;
    }

    void fuseEqualParameters(HLTrans t) {
        if (t.getParams().size() < 2) {
            return;
        }
        if (t.getGuard().getOp() != Op.BOOLCONST) {
            while (this.handleEqual(t.getGuard(), t)) {
            }
        }
    }

    public void simplifyLogic() {
        for (Property prop : this.getProperties()) {
            prop.setBody(Simplifier.pushNegation(prop.getBody()));
            prop.setBody(Simplifier.simplifySumComparisons(prop.getBody()));
            prop.setBody(Simplifier.assumeVarsPositive(prop.getBody()));
            prop.setBody(Simplifier.simplifyBoolean(prop.getBody()));
        }
    }

    private boolean handleEqual(Expression guard, HLTrans t) {
        if (guard.getOp() == Op.AND) {
            guard.forEachChild(c -> this.handleEqual((Expression)c, t));
        } else if (guard.getOp() == Op.EQ && guard instanceof BinOp) {
            BinOp bin = (BinOp)guard;
            if (bin.left.getOp() == Op.PARAMREF && bin.right.getOp() == Op.PARAMREF && !bin.left.equals(bin.right)) {
                this.remapParameter(t, ((ParamRef)bin.left).parameter, ((ParamRef)bin.right).parameter);
            }
        }
        return false;
    }

    private void remapParameter(HLTrans t, Param tokeep, Param todel) {
        for (HLArc arc : t.getPre()) {
            for (Expression e : arc.getCfunc()) {
                this.remapParameter(e, tokeep, todel);
            }
        }
        for (HLArc arc : t.getPost()) {
            for (Expression e : arc.getCfunc()) {
                this.remapParameter(e, tokeep, todel);
            }
        }
        this.remapParameter(t.getGuard(), tokeep, todel);
        t.getParams().remove(todel);
    }

    private Void remapParameter(Expression expr, Param tokeep, Param todel) {
        if (expr == null) {
            return null;
        }
        if (expr instanceof BinOp) {
            BinOp bin = (BinOp)expr;
            bin.forEachChild(c -> this.remapParameter((Expression)c, tokeep, todel));
        } else if (expr instanceof NaryOp) {
            NaryOp nop = (NaryOp)expr;
            nop.forEachChild(c -> this.remapParameter((Expression)c, tokeep, todel));
        } else if (expr instanceof ParamRef) {
            ParamRef pref = (ParamRef)expr;
            if (pref.parameter == todel) {
                pref.parameter = tokeep;
            }
        } else if (expr instanceof ArrayVarRef) {
            ArrayVarRef aref = (ArrayVarRef)expr;
            this.remapParameter(aref.index, tokeep, todel);
        }
        return null;
    }

    private Expression bindSkeletonColors(Expression expr) {
        if (expr == null) {
            return expr;
        }
        if (expr instanceof BinOp) {
            BinOp bin = (BinOp)expr;
            Expression l = this.bindSkeletonColors(bin.left);
            Expression r = this.bindSkeletonColors(bin.right);
            if (l == bin.left && r == bin.right) {
                return expr;
            }
            return Expression.op(bin.op, l, r);
        }
        if (expr instanceof NaryOp) {
            NaryOp nop = (NaryOp)expr;
            ArrayList<Expression> resc = new ArrayList<Expression>();
            if (expr.getOp() == Op.CARD || expr.getOp() == Op.BOUND) {
                for (Expression child : nop.getChildren()) {
                    if (child.getOp() != Op.PLACEREF) continue;
                    if (this.places.get(child.getValue()).isConstant()) {
                        int sum = 0;
                        int[] nArray = this.places.get(child.getValue()).getInitial();
                        int n = nArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            int v = nArray[n2];
                            sum += v;
                            ++n2;
                        }
                        resc.add(Expression.constant(sum));
                        continue;
                    }
                    resc.add(Expression.var(child.getValue()));
                }
                return Expression.nop(nop.getOp(), resc);
            }
            if (expr.getOp() == Op.ENABLED) {
                for (Expression child : nop.getChildren()) {
                    if (child.getOp() != Op.TRANSREF) continue;
                    resc.add(Expression.trans(child.getValue()));
                }
                return Expression.nop(nop.getOp(), resc);
            }
            boolean changed = false;
            for (Expression child : nop.getChildren()) {
                Expression nc = this.bindSkeletonColors(child);
                resc.add(nc);
                if (nc == child) continue;
                changed = true;
            }
            if (!changed) {
                return expr;
            }
            return Expression.nop(nop.getOp(), resc);
        }
        if (expr instanceof ArrayVarRef) {
            ArrayVarRef aref = (ArrayVarRef)expr;
            return Expression.var(aref.base);
        }
        return expr;
    }

    private Expression bindColors(Expression expr, List<List<Integer>> en) {
        if (expr == null) {
            return expr;
        }
        if (expr instanceof BinOp) {
            BinOp bin = (BinOp)expr;
            Expression l = this.bindColors(bin.left, en);
            Expression r = this.bindColors(bin.right, en);
            if (l == bin.left && r == bin.right) {
                return expr;
            }
            return Expression.op(bin.op, l, r);
        }
        if (expr instanceof NaryOp) {
            NaryOp nop = (NaryOp)expr;
            ArrayList<Expression> resc = new ArrayList<Expression>();
            if (expr.getOp() == Op.CARD || expr.getOp() == Op.BOUND) {
                for (Expression child : nop.getChildren()) {
                    if (child.getOp() != Op.PLACEREF) continue;
                    if (this.places.get(child.getValue()).isConstant()) {
                        int sum = 0;
                        int[] nArray = this.places.get(child.getValue()).getInitial();
                        int n = nArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            int v = nArray[n2];
                            sum += v;
                            ++n2;
                        }
                        resc.add(Expression.constant(sum));
                        continue;
                    }
                    int si = this.places.get(child.getValue()).getStartIndex();
                    int i = 0;
                    int ie = this.places.get(child.getValue()).getInitial().length;
                    while (i < ie) {
                        resc.add(Expression.var(si + i));
                        ++i;
                    }
                }
                return Expression.nop(nop.getOp(), resc);
            }
            if (expr.getOp() == Op.ENABLED) {
                for (Expression child : nop.getChildren()) {
                    if (child.getOp() != Op.TRANSREF) continue;
                    for (Integer timg : en.get(child.getValue())) {
                        resc.add(Expression.trans(timg));
                    }
                }
                return Expression.nop(nop.getOp(), resc);
            }
            boolean changed = false;
            for (Expression child : nop.getChildren()) {
                Expression nc = this.bindColors(child, en);
                resc.add(nc);
                if (nc == child) continue;
                changed = true;
            }
            if (!changed) {
                return expr;
            }
            return Expression.nop(nop.getOp(), resc);
        }
        if (expr instanceof ArrayVarRef) {
            throw new IllegalArgumentException("Expression " + String.valueOf(expr) + " is an array.");
        }
        return expr;
    }

    public static Expression bind(Param cur, int val, Expression expr) {
        if (expr == null) {
            return expr;
        }
        if (expr.getOp() == Op.PARAMREF) {
            ParamRef pref = (ParamRef)expr;
            if (pref.parameter.equals(cur)) {
                return Expression.constant(val);
            }
        } else {
            if (expr instanceof BinOp) {
                BinOp bin = (BinOp)expr;
                Expression l = SparseHLPetriNet.bind(cur, val, bin.left);
                Expression r = SparseHLPetriNet.bind(cur, val, bin.right);
                if (l.getOp() == Op.BOOLCONST && (r == null || r.getOp() == Op.BOOLCONST)) {
                    boolean v = new BinOp(expr.getOp(), l, r).eval(null) == 1;
                    return Expression.constant(v);
                }
                if (l == bin.left && r == bin.right) {
                    return expr;
                }
                return Expression.op(bin.op, l, r);
            }
            if (expr instanceof NaryOp) {
                NaryOp nop = (NaryOp)expr;
                ArrayList<Expression> resc = new ArrayList<Expression>();
                boolean changed = false;
                boolean allConst = true;
                for (Expression child : nop.getChildren()) {
                    Expression nc = SparseHLPetriNet.bind(cur, val, child);
                    resc.add(nc);
                    if (nc != child) {
                        changed = true;
                        if (nc.getOp() == Op.BOOLCONST && (nc.getValue() == 0 && expr.getOp() == Op.AND || nc.getValue() == 1 && expr.getOp() == Op.OR)) {
                            return nc;
                        }
                    }
                    if (!allConst || nc.getOp() == Op.BOOLCONST || nc.getOp() == Op.CONST) continue;
                    allConst = false;
                }
                if (!changed) {
                    return expr;
                }
                if (allConst) {
                    int v = Expression.nop(nop.getOp(), resc).eval(null);
                    if (nop.getOp() == Op.AND || nop.getOp() == Op.OR) {
                        return Expression.constant(v == 1);
                    }
                    return Expression.constant(v);
                }
                return Expression.nop(nop.getOp(), resc);
            }
            if (expr instanceof ArrayVarRef) {
                ArrayVarRef aref = (ArrayVarRef)expr;
                Expression index = SparseHLPetriNet.bind(cur, val, aref.index);
                if (index == aref.index) {
                    return aref;
                }
                return new ArrayVarRef(aref.base, index);
            }
        }
        return expr;
    }

    private int transformHLtoPT(HLTrans bt, SparsePetriNet spn) {
        boolean hasNeg = false;
        SparseIntArray pt = new SparseIntArray();
        for (HLArc arc : bt.getPre()) {
            HLPlace hlplace = this.places.get(arc.getPlace());
            int pind = hlplace.getStartIndex();
            int offset = hlplace.resolve(arc.getCfunc());
            int finalp = pind + offset;
            int val = pt.get(finalp) + arc.getCoeff();
            pt.put(finalp, val);
            if (val >= 0) continue;
            hasNeg = true;
        }
        if (hasNeg) {
            hasNeg = false;
            int i = 0;
            int ie = pt.size();
            while (i < ie) {
                if (pt.valueAt(i) < 0) {
                    Logger.getLogger("fr.lip6.move.gal").info("Discarding a negative binding.");
                    return -1;
                }
                ++i;
            }
        }
        SparseIntArray tp = new SparseIntArray();
        for (HLArc arc : bt.getPost()) {
            HLPlace hlplace = this.places.get(arc.getPlace());
            int pind = hlplace.getStartIndex();
            int offset = hlplace.resolve(arc.getCfunc());
            int finalp = pind + offset;
            int val = tp.get(finalp) + arc.getCoeff();
            tp.put(finalp, val);
            if (val >= 0) continue;
            hasNeg = true;
        }
        if (hasNeg) {
            int i = 0;
            int ie = tp.size();
            while (i < ie) {
                if (tp.valueAt(i) < 0) {
                    Logger.getLogger("fr.lip6.move.gal").info("Discarding a negative binding.");
                    return -1;
                }
                ++i;
            }
        }
        int tind = spn.addTransition(bt.getName());
        int i = 0;
        int ie = pt.size();
        while (i < ie) {
            spn.addPreArc(pt.keyAt(i), tind, pt.valueAt(i));
            ++i;
        }
        i = 0;
        ie = tp.size();
        while (i < ie) {
            spn.addPostArc(tp.keyAt(i), tind, tp.valueAt(i));
            ++i;
        }
        return tind;
    }

    public void dropAllExcept(Set<Integer> safeNodes) {
        int pid;
        int[] perm = new int[this.places.size()];
        int i = 0;
        int ind = 0;
        while (i < this.places.size()) {
            perm[i] = safeNodes.contains(i) ? ind++ : -1;
            ++i;
        }
        int trem = 0;
        int prem = 0;
        int tid = this.transitions.size() - 1;
        while (tid >= 0) {
            for (HLArc arc2 : this.transitions.get(tid).getPre()) {
                pid = arc2.getPlace();
                if (!safeNodes.contains(pid)) {
                    this.transitions.remove(tid);
                    ++trem;
                    break;
                }
                arc2.setPlace(perm[pid]);
            }
            --tid;
        }
        tid = this.transitions.size() - 1;
        while (tid >= 0) {
            for (HLArc arc2 : this.transitions.get(tid).getPost()) {
                pid = arc2.getPlace();
                arc2.setPlace(perm[pid]);
            }
            this.transitions.get(tid).getPost().removeIf(arc -> arc.getPlace() == -1);
            --tid;
        }
        int pid2 = this.places.size() - 1;
        while (pid2 >= 0) {
            if (!safeNodes.contains(pid2)) {
                this.places.remove(pid2);
                ++prem;
            }
            --pid2;
        }
        this.resetPlaceCount();
        System.out.println("Prefix of Interest using HLPN skeleton for deadlock discarded " + prem + " places and " + trem + " transitions.");
    }

    public void resetPlaceCount() {
        this.placeCount = 0;
        int pid = 0;
        int pide = this.places.size();
        while (pid < pide) {
            this.places.get(pid).setStartIndex(this.placeCount);
            this.placeCount += this.places.get(pid).getInitial().length;
            ++pid;
        }
    }

    public static String sortName(List<Sort> sort) {
        StringBuilder sb = new StringBuilder();
        for (Sort s : sort) {
            sb.append(s.getName());
        }
        return sb.toString();
    }

    private boolean hasNoGuardedEnablingCombinations(Property p) {
        HashSet<Integer> targets = new HashSet<Integer>();
        SparseHLPetriNet.findEnablings(p.getBody(), targets);
        boolean hasGuards = targets.stream().anyMatch(tid -> this.getTransitions().get((int)tid).getGuard().getOp() != Op.BOOLCONST);
        if (hasGuards) {
            int pid;
            HLTrans trans;
            int tid2;
            HashSet<Integer> guardedPlaces = new HashSet<Integer>();
            Iterator iterator = targets.iterator();
            while (iterator.hasNext()) {
                tid2 = (Integer)iterator.next();
                trans = this.getTransitions().get(tid2);
                if (trans.getGuard().getOp() == Op.BOOLCONST) continue;
                for (HLArc arc : trans.getPre()) {
                    pid = arc.getPlace();
                    if (guardedPlaces.add(pid)) continue;
                    return false;
                }
            }
            iterator = targets.iterator();
            while (iterator.hasNext()) {
                tid2 = (Integer)iterator.next();
                trans = this.getTransitions().get(tid2);
                if (trans.getGuard().getOp() != Op.BOOLCONST) continue;
                for (HLArc arc : trans.getPre()) {
                    pid = arc.getPlace();
                    if (!guardedPlaces.contains(pid)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    private static void findEnablings(Expression e, Set<Integer> targets) {
        if (e == null || Op.isComparison(e.getOp())) {
            return;
        }
        if (e.getOp() == Op.ENABLED) {
            int cid = 0;
            int cide = e.nbChildren();
            while (cid < cide) {
                targets.add(e.childAt(cid).getValue());
                ++cid;
            }
        } else {
            int cid = 0;
            int cide = e.nbChildren();
            while (cid < cide) {
                SparseHLPetriNet.findEnablings(e.childAt(cid), targets);
                ++cid;
            }
        }
    }
}

