/*
 * Decompiled with CFR 0.152.
 */
package fr.lip6.move.gal.structural.hlpn;

import fr.lip6.move.gal.structural.expr.Expression;
import fr.lip6.move.gal.structural.expr.Op;
import fr.lip6.move.gal.structural.expr.Param;
import fr.lip6.move.gal.structural.expr.ParamRef;
import fr.lip6.move.gal.structural.hlpn.HLArc;
import fr.lip6.move.gal.structural.hlpn.HLPlace;
import fr.lip6.move.gal.structural.hlpn.HLTrans;
import fr.lip6.move.gal.structural.hlpn.Partition;
import fr.lip6.move.gal.structural.hlpn.Sort;
import fr.lip6.move.gal.structural.hlpn.SparseHLPetriNet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;

public class SymmetricUnfolder {
    private static final int DEBUG = 1;
    private static final Strategy strategy = Strategy.CONSERVATIVE;

    private static Void computeParams(Expression e, List<Param> params) {
        if (e == null) {
            return null;
        }
        if (e instanceof ParamRef) {
            ParamRef pr = (ParamRef)e;
            if (!params.contains(pr.parameter)) {
                params.add(pr.parameter);
            }
        } else {
            e.forEachChild(c -> SymmetricUnfolder.computeParams(c, params));
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public static void testSymmetryConditions(SparseHLPetriNet net) {
        for (HLTrans trans : net.getTransitions()) {
            net.fuseEqualParameters(trans);
        }
        net.getSorts().sort((a, b) -> -Integer.compare(a.size(), b.size()));
        for (Sort sort : net.getSorts()) {
            if (sort.size() == 1) continue;
            boolean isSym = true;
            HashMap<Integer, Integer> touchedPlaces = new HashMap<Integer, Integer>();
            int placeid = -1;
            for (HLPlace hLPlace : net.getPlaces()) {
                ++placeid;
                int sortindex = -1;
                int i = 0;
                while (i < hLPlace.getSort().size()) {
                    if (hLPlace.getSort().get(i).equals(sort)) {
                        if (sortindex != -1) {
                            isSym = false;
                            System.out.println("Domain " + String.valueOf(hLPlace.getSort()) + " of place " + hLPlace.getName() + " breaks symmetries in sort " + sort.getName());
                            break;
                        }
                        sortindex = i;
                    }
                    ++i;
                }
                if (!isSym) break;
                if (sortindex == -1) continue;
                touchedPlaces.put(placeid, sortindex);
            }
            if (!isSym) continue;
            for (HLTrans trans2 : net.getTransitions()) {
                for (HLArc hLArc : trans2.getPre()) {
                    Integer sortind = (Integer)touchedPlaces.get(hLArc.getPlace());
                    if (sortind == null || hLArc.getCfunc().get(sortind).getOp() != Op.MOD) continue;
                    isSym = false;
                    System.out.println("Arc " + String.valueOf(hLArc) + " contains successor/predecessor on variables of sort " + sort.getName());
                    break;
                }
                if (!isSym) break;
                for (HLArc hLArc : trans2.getPost()) {
                    Integer sortind = (Integer)touchedPlaces.get(hLArc.getPlace());
                    if (sortind == null || hLArc.getCfunc().get(sortind).getOp() != Op.MOD) continue;
                    isSym = false;
                    System.out.println("Arc " + String.valueOf(hLArc) + " contains successor/predecessor on variables of sort " + sort.getName());
                    break;
                }
                if (!isSym) break;
            }
            if (!isSym) continue;
            Partition partition = new Partition(sort.size());
            for (HLTrans hLTrans : net.getTransitions()) {
                block8: for (Param param : hLTrans.getParams()) {
                    if (!param.getSort().equals(sort.getName())) continue;
                    int seenplace = -1;
                    for (HLArc arc3 : hLTrans.getPre()) {
                        Integer sortind = (Integer)touchedPlaces.get(arc3.getPlace());
                        if (sortind == null) continue;
                        ArrayList<Param> refs = new ArrayList<Param>();
                        SymmetricUnfolder.computeParams(arc3.getCfunc().get(sortind), refs);
                        if (!refs.contains(param)) continue;
                        if (seenplace == -1) {
                            seenplace = arc3.getPlace();
                            continue;
                        }
                        if (seenplace == arc3.getPlace()) continue;
                        System.out.println("Transition " + hLTrans.getName() + " forces synchronizations/join behavior on parameter " + param.getName() + " of sort " + sort.getName());
                        if (strategy == Strategy.THAT_ONE_GUY) {
                            Partition p2 = new Partition(sort.size(), Collections.singletonList(0));
                            partition = Partition.refine(partition, p2);
                            continue block8;
                        }
                        if (strategy == Strategy.FORKJOIN) continue block8;
                        isSym = false;
                        continue block8;
                    }
                }
                if (!isSym) break;
            }
            if (!isSym) continue;
            System.out.println("Symmetric sort wr.t. initial and guards and successors and join/free detected :" + sort.getName());
            for (HLTrans hLTrans : net.getTransitions()) {
                AtomicBoolean ab = new AtomicBoolean(isSym);
                partition = SymmetricUnfolder.computeArcSymmetry(net, sort, hLTrans, hLTrans.getPre(), touchedPlaces, partition, ab);
                isSym = ab.get();
                if (!isSym) break;
                partition = SymmetricUnfolder.computeArcSymmetry(net, sort, hLTrans, hLTrans.getPost(), touchedPlaces, partition, ab);
                isSym = ab.get();
                if (!isSym) break;
            }
            if (!isSym || !isSym) continue;
            System.out.println("Symmetric sort wr.t. initial detected :" + sort.getName());
            for (HLTrans hLTrans : net.getTransitions()) {
                if (hLTrans.getGuard() != null && hLTrans.getGuard().getOp() != Op.BOOLCONST) {
                    ArrayList<Param> refs = new ArrayList<Param>();
                    SymmetricUnfolder.computeParams(hLTrans.getGuard(), refs);
                    for (Param cur : refs) {
                        if (!cur.getSort().equals(sort.getName())) continue;
                        HashMap<Expression, List> localpart = new HashMap<Expression, List>();
                        int val = 0;
                        while (val < cur.size()) {
                            Expression guard = SparseHLPetriNet.bind(cur, val, hLTrans.getGuard());
                            localpart.computeIfAbsent(guard, k -> new ArrayList()).add(val);
                            ++val;
                        }
                        if (localpart.size() == 1) continue;
                        System.out.println("Transition " + hLTrans.getName() + " : guard parameter " + String.valueOf(cur) + " in guard " + String.valueOf(hLTrans.getGuard()) + "introduces in " + String.valueOf(sort) + " partition with " + localpart.size() + " elements");
                        partition = Partition.refine(new Partition(localpart.values()), partition);
                        if (partition.getNbSubs() != sort.size()) continue;
                        isSym = false;
                        break;
                    }
                    if (isSym) {
                        refs.removeIf(p -> !p.getSort().equals(sort.getName()));
                        if (refs.size() > 1 && SymmetricUnfolder.containsSyncsOn(hLTrans.getGuard(), sort.getName())) {
                            System.out.println("Transition " + hLTrans.getName() + " : guard " + String.valueOf(hLTrans.getGuard()) + " contains nasty synchronization on some of " + String.valueOf(refs));
                            isSym = false;
                        }
                    }
                }
                if (!isSym) break;
            }
            if (!isSym) continue;
            if (partition.getNbSubs() == 1) {
                System.out.println("Symmetric sort wr.t. initial and guards detected :" + sort.getName());
            } else {
                System.out.println("Sort wr.t. initial and guards " + sort.getName() + " has partition " + partition.getNbSubs());
            }
            if (partition.getNbSubs() == 1) {
                System.out.println("Applying symmetric unfolding of full symmetric sort :" + sort.getName() + " domain size was " + sort.size());
            } else {
                System.out.println("Applying symmetric unfolding of partitioned symmetric sort :" + sort.getName() + " domain size was " + sort.size() + " reducing to " + partition.getNbSubs() + " values.");
            }
            int n = -1;
            for (HLPlace hLPlace : net.getPlaces()) {
                void var6_17;
                Integer sortindex;
                if ((sortindex = (Integer)touchedPlaces.get((int)(++var6_17))) == null) continue;
                int[] after = partition.rewriteMarking(hLPlace, sortindex);
                hLPlace.setInitial(after);
            }
            net.resetPlaceCount();
            for (HLTrans hLTrans : net.getTransitions()) {
                ArrayList<Param> refs = new ArrayList<Param>();
                SymmetricUnfolder.computeParams(hLTrans.getGuard(), refs);
                for (Param par : hLTrans.getParams()) {
                    if (!par.getSort().equals(sort.getName())) continue;
                    boolean touchGuard = refs.contains(par);
                    HashMap<Expression, List> partition2 = new HashMap<Expression, List>();
                    if (touchGuard) {
                        int val = 0;
                        while (val < par.size()) {
                            Expression guard = SparseHLPetriNet.bind(par, val, hLTrans.getGuard());
                            partition2.computeIfAbsent(guard, k -> new ArrayList()).add(val);
                            ++val;
                        }
                    }
                    par.setSize(partition.getNbSubs());
                    if (!touchGuard) continue;
                    ArrayList<Expression> result = new ArrayList<Expression>();
                    for (Map.Entry ent : partition2.entrySet()) {
                        List<Integer> cover = partition.covers((List)ent.getValue());
                        ArrayList<Expression> toOr = new ArrayList<Expression>();
                        for (Integer i : cover) {
                            toOr.add(Expression.op(Op.EQ, Expression.paramRef(par), Expression.constant(i)));
                        }
                        result.add(Expression.op(Op.AND, (Expression)ent.getKey(), Expression.nop(Op.OR, toOr)));
                    }
                    Expression newguard = Expression.nop(Op.OR, result);
                    System.out.println("For transition " + hLTrans.getName() + ":" + String.valueOf(hLTrans.getGuard()) + " -> " + String.valueOf(newguard));
                    hLTrans.setGuard(newguard);
                }
                for (HLArc arc4 : hLTrans.getPre()) {
                    Integer sortindex = (Integer)touchedPlaces.get(arc4.getPlace());
                    if (sortindex == null || arc4.getCfunc().get(sortindex).getOp() != Op.CONST) continue;
                    int target = arc4.getCfunc().get(sortindex).getValue();
                    int img = partition.getImage(target);
                    arc4.setCFuncElt(sortindex, Expression.constant(img));
                }
                for (HLArc arc5 : hLTrans.getPost()) {
                    Integer sortindex = (Integer)touchedPlaces.get(arc5.getPlace());
                    if (sortindex == null || arc5.getCfunc().get(sortindex).getOp() != Op.CONST) continue;
                    int target = arc5.getCfunc().get(sortindex).getValue();
                    int img = partition.getImage(target);
                    arc5.setCFuncElt(sortindex, Expression.constant(img));
                }
            }
            sort.setSize(partition.getNbSubs());
        }
    }

    public static Partition computeArcSymmetry(SparseHLPetriNet net, Sort sort, HLTrans trans, List<HLArc> arcs, Map<Integer, Integer> touchedPlaces, Partition partition, AtomicBoolean ab) {
        HashMap<Integer, List> constFuncArcs = new HashMap<Integer, List>();
        for (HLArc hLArc : arcs) {
            Integer sortind = touchedPlaces.get(hLArc.getPlace());
            if (sortind == null || hLArc.getCfunc().get(sortind).getOp() != Op.CONST) continue;
            constFuncArcs.computeIfAbsent(hLArc.getPlace(), x -> new ArrayList()).add(hLArc);
            System.out.println("Arc " + String.valueOf(hLArc) + " contains constants of sort " + sort.getName());
        }
        if (!constFuncArcs.isEmpty()) {
            for (Map.Entry entry : constFuncArcs.entrySet()) {
                int place = (Integer)entry.getKey();
                int sortindex = touchedPlaces.get(place);
                for (HLArc a : (List)entry.getValue()) {
                    if (a.getCoeff() == 1) continue;
                    ab.set(false);
                    break;
                }
                if (!ab.get()) break;
                HashMap<List, List> localpart = new HashMap<List, List>();
                List<Sort> psort = net.getPlaces().get(place).getSort();
                for (HLArc a : (List)entry.getValue()) {
                    ArrayList<Expression> l = new ArrayList<Expression>(psort.size() - 1);
                    int i = 0;
                    while (i < psort.size()) {
                        if (i != sortindex) {
                            l.add(a.getCfunc().get(i));
                        }
                        ++i;
                    }
                    localpart.computeIfAbsent(l, k -> new ArrayList()).add(a.getCfunc().get(sortindex).getValue());
                }
                for (List l : localpart.values()) {
                    Partition p2 = new Partition(sort.size(), l);
                    partition = Partition.refine(p2, partition);
                    if (partition.getNbSubs() != sort.size()) continue;
                    ab.set(false);
                    break;
                }
                System.out.println("Transition " + trans.getName() + " : constants on arcs in " + String.valueOf(entry.getValue()) + " introduces in " + String.valueOf(sort) + " partition with " + localpart.size() + " elements that refines current partition to " + partition.getNbSubs() + " subsets.");
            }
        }
        return partition;
    }

    private static boolean containsSyncsOn(Expression e, String sortname) {
        if (e == null) {
            return false;
        }
        switch (e.getOp()) {
            case EQ: 
            case NEQ: 
            case GEQ: 
            case GT: 
            case LEQ: 
            case LT: {
                ArrayList<Param> refs = new ArrayList<Param>();
                SymmetricUnfolder.computeParams(e, refs);
                refs.removeIf(p -> !p.getSort().equals(sortname));
                return refs.size() >= 2;
            }
        }
        int i = 0;
        while (i < e.nbChildren()) {
            if (SymmetricUnfolder.containsSyncsOn(e.childAt(i), sortname)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static enum Strategy {
        CONSERVATIVE,
        THAT_ONE_GUY,
        FORKJOIN;

    }
}

