/*
 * Decompiled with CFR 0.152.
 */
package fr.lip6.move.gal.structural.pnml;

import fr.lip6.move.gal.structural.SparsePetriNet;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.logging.Logger;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class PTNetHandler
extends DefaultHandler {
    static final String PTNET = "http://www.pnml.org/version-2009/grammar/ptnet";
    private static final boolean IGNORE_NAMES = true;
    private final Logger logger = Logger.getLogger("fr.lip6.move.gal");
    private Stack<Object> stack = new Stack();
    private SparsePetriNet net = new SparsePetriNet();
    private Map<String, Node> nodes = new LinkedHashMap<String, Node>();
    private List<Arc> topatch = new ArrayList<Arc>();
    private String lastseen = null;
    private boolean readtext = false;
    private Long lastint = null;
    private boolean readint = false;
    private StringBuilder textBuffer = new StringBuilder();
    private boolean inOpaqueToolSpecific = false;
    private boolean doIt = false;

    @Override
    public void characters(char[] chars, int beg, int length) throws SAXException {
        if (this.inOpaqueToolSpecific) {
            return;
        }
        if (this.doIt && (this.readtext || this.readint)) {
            this.textBuffer.append(chars, beg, length);
        }
    }

    @Override
    public final void startElement(String uri, String localName, String baliseName, Attributes attributes) throws SAXException {
        if ("net".equals(baliseName)) {
            this.net.setName(attributes.getValue("id"));
            String type = attributes.getValue("type");
            if (!PTNET.equals(type)) {
                throw new IllegalArgumentException("Parser only supports ptnet grammar. Type " + type + " is not supported.");
            }
            this.logger.info("Found a PT net.");
            this.stack.push(this.net);
        } else if ("name".equals(baliseName)) {
            this.readtext = true;
            this.textBuffer.setLength(0);
        } else if (!"page".equals(baliseName)) {
            if ("place".equals(baliseName)) {
                String id = PTNetHandler.normalizeName(attributes.getValue("id"));
                int pindex = this.net.addPlace(id, 0);
                Node place = new Node(NodeType.PLACE, pindex);
                this.nodes.put(id, place);
                this.stack.push(place);
            } else if ("initialMarking".equals(baliseName)) {
                this.readint = true;
                this.textBuffer.setLength(0);
            } else if ("inscription".equals(baliseName)) {
                this.readint = true;
                this.textBuffer.setLength(0);
            } else if ("transition".equals(baliseName)) {
                String id = PTNetHandler.normalizeName(attributes.getValue("id"));
                int tindex = this.net.addTransition(id);
                Node trans = new Node(NodeType.TRANSITION, tindex);
                this.nodes.put(id, trans);
                this.stack.push(trans);
            } else if ("arc".equals(baliseName)) {
                Arc arc = new Arc(attributes.getValue("source"), attributes.getValue("target"), 1);
                this.topatch.add(arc);
                this.stack.push(arc);
            } else if ("toolspecific".equals(baliseName)) {
                this.logger.warning("Skipping unknown tool specific annotation : " + attributes.getValue("tool"));
                this.inOpaqueToolSpecific = true;
            } else if ("text".equals(baliseName)) {
                this.doIt = true;
            } else if (!("graphics".equals(baliseName) || "offset".equals(baliseName) || "position".equals(baliseName) || "fill".equals(baliseName) || "line".equals(baliseName) || "dimension".equals(baliseName) || "pnml".equals(baliseName))) {
                this.logger.warning("Unknown XML tag in source file: " + baliseName);
            }
        }
    }

    public static String normalizeName(String text) {
        String res = text.replace(' ', '_');
        res = res.replace('-', '_');
        res = res.replace('/', '_');
        res = res.replace('*', 'x');
        res = res.replace('=', '_');
        return res;
    }

    @Override
    public final void endElement(String uri, String localName, String baliseName) throws SAXException {
        if ("toolspecific".equals(baliseName)) {
            if (this.inOpaqueToolSpecific) {
                this.inOpaqueToolSpecific = false;
            }
        } else {
            if (this.inOpaqueToolSpecific) {
                return;
            }
            if ("net".equals(baliseName)) {
                this.stack.pop();
                assert (this.stack.isEmpty());
            } else if ("name".equals(baliseName)) {
                Object context = this.stack.peek();
                this.lastseen = this.textBuffer.toString().trim();
                if (context instanceof SparsePetriNet) {
                    SparsePetriNet spn = (SparsePetriNet)context;
                    spn.setName(this.lastseen);
                } else if (context instanceof Node) {
                    Node node = (Node)context;
                    if (node.type == NodeType.PLACE) {
                        this.net.getPnames().set(node.index, PTNetHandler.normalizeName(this.lastseen));
                    } else if (node.type == NodeType.TRANSITION) {
                        this.net.getTnames().set(node.index, PTNetHandler.normalizeName(this.lastseen));
                    }
                } else {
                    this.logger.warning("Unexpected name tag in source file: " + baliseName + " context =" + context.getClass().getName());
                }
                this.readtext = false;
                this.lastseen = null;
                this.textBuffer.setLength(0);
            } else if (!"page".equals(baliseName)) {
                if ("place".equals(baliseName)) {
                    this.stack.pop();
                } else if ("transition".equals(baliseName)) {
                    this.stack.pop();
                } else if ("arc".equals(baliseName)) {
                    this.stack.pop();
                } else if ("text".equals(baliseName)) {
                    this.doIt = false;
                } else if ("initialMarking".equals(baliseName)) {
                    Node p = (Node)this.stack.peek();
                    this.lastint = Long.parseLong(this.textBuffer.toString().trim());
                    this.net.getMarks().set(p.index, Math.toIntExact(this.lastint));
                    this.readint = false;
                    this.lastint = null;
                    this.textBuffer.setLength(0);
                } else if ("inscription".equals(baliseName)) {
                    Arc p = (Arc)this.stack.peek();
                    this.lastint = Long.parseLong(this.textBuffer.toString().trim());
                    p.value = Math.toIntExact(this.lastint);
                    this.readint = false;
                    this.lastint = null;
                    this.textBuffer.setLength(0);
                } else if (!("graphics".equals(baliseName) || "offset".equals(baliseName) || "position".equals(baliseName) || "fill".equals(baliseName) || "line".equals(baliseName) || "dimension".equals(baliseName))) {
                    if ("pnml".equals(baliseName)) {
                        for (Arc arc : this.topatch) {
                            Node src = this.nodes.get(arc.source);
                            Node target = this.nodes.get(arc.target);
                            int value = arc.value;
                            if (src == null || target == null) {
                                throw new RuntimeException("Problem when linking arc " + String.valueOf(arc));
                            }
                            if (src.type == NodeType.PLACE) {
                                this.net.addPreArc(src.index, target.index, value);
                                continue;
                            }
                            if (src.type != NodeType.TRANSITION) continue;
                            this.net.addPostArc(src.index, target.index, value);
                        }
                    } else {
                        this.logger.warning("Unknown XML tag in source file: " + baliseName);
                    }
                }
            }
        }
    }

    public SparsePetriNet getParseResult() {
        return this.net;
    }

    private static class Arc {
        String source;
        String target;
        int value;

        public Arc(String source, String target, int value) {
            this.source = source;
            this.target = target;
            this.value = value;
        }
    }

    private record Node(NodeType type, int index) {
    }

    private static enum NodeType {
        PLACE,
        TRANSITION;

    }
}

