/*
 * Decompiled with CFR 0.152.
 */
package fr.lip6.move.gal.structural.pnml;

import fr.lip6.move.gal.structural.SparsePetriNet;
import fr.lip6.move.gal.structural.pnml.PTNetHandler;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Logger;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public final class PTNetReader {
    private static final Logger LOGGER = Logger.getLogger("fr.lip6.move.gal");
    private SparsePetriNet net = null;

    public SparsePetriNet loadFromXML(File ff) throws IOException, IllegalArgumentException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (BufferedInputStream fis = new BufferedInputStream(new FileInputStream(ff));){
            return this.loadFromXML(fis);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public SparsePetriNet loadFromXML(InputStream in) throws IllegalArgumentException {
        PTNetHandler modelHandler = new PTNetHandler();
        SAXParserFactory factory = SAXParserFactory.newInstance();
        try {
            SAXParser saxParser = factory.newSAXParser();
            long debut = System.currentTimeMillis();
            saxParser.parse(in, (DefaultHandler)modelHandler);
            LOGGER.info("Load time of PNML (sax parser for PT used): " + (System.currentTimeMillis() - debut) + " ms");
        }
        catch (SAXException e) {
            LOGGER.warning("Parse error while parsing toolspecific elements in pnml.\n details:" + e.getMessage());
            e.printStackTrace();
        }
        catch (IOException e) {
            LOGGER.warning("IO exception : " + e.getMessage());
        }
        catch (ParserConfigurationException e) {
            LOGGER.warning("Error in parser configuration. " + e.getMessage());
            e.printStackTrace();
        }
        this.net = modelHandler.getParseResult();
        return modelHandler.getParseResult();
    }

    public SparsePetriNet getNet() {
        return this.net;
    }
}

