/*
 * Decompiled with CFR 0.152.
 */
package fr.lip6.move.gal.structural.tar;

import fr.lip6.move.gal.structural.tar.AutomataEdge;
import fr.lip6.move.gal.structural.tar.PlaceRangeVector;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class AutomataState {
    private List<AutomataEdge> edges = new ArrayList<AutomataEdge>();
    private boolean accept = false;
    private List<Integer> simulates = new ArrayList<Integer>();
    private List<Integer> simulators = new ArrayList<Integer>();
    private PlaceRangeVector interpolant;

    public AutomataState(PlaceRangeVector interpolant) {
        this.interpolant = interpolant;
    }

    public boolean isAccept() {
        return this.accept;
    }

    public void setAccept(boolean accept) {
        this.accept = accept;
    }

    public boolean hasEdge(int from, int to) {
        int index = Collections.binarySearch(this.edges, new AutomataEdge(from));
        if (index < 0) {
            return false;
        }
        return this.edges.get(index).hasTo(to);
    }

    public boolean addEdge(int from, int to) {
        AutomataEdge edge = new AutomataEdge(from);
        int index = Collections.binarySearch(this.edges, edge);
        if (index < 0) {
            this.edges.add(-(index + 1), edge);
        } else {
            edge = this.edges.get(index);
        }
        return edge.addTo(to);
    }

    public boolean removeEdge(int from, int to) {
        AutomataEdge edge = new AutomataEdge(from);
        int index = Collections.binarySearch(this.edges, edge);
        if (index < 0) {
            return false;
        }
        return this.edges.get(index).remove(to);
    }

    public boolean removeEdge(int from) {
        AutomataEdge edge = new AutomataEdge(from);
        int index = Collections.binarySearch(this.edges, edge);
        if (index < 0) {
            return false;
        }
        this.edges.remove(index);
        return true;
    }

    public List<AutomataEdge> getEdges() {
        return this.edges;
    }

    public String toString() {
        return "AutomataState [interpolant=" + String.valueOf(this.interpolant) + ", simulates=" + String.valueOf(this.simulates) + ", simulators=" + String.valueOf(this.simulators) + ", edges=" + String.valueOf(this.edges) + "]";
    }

    public PlaceRangeVector getInterpolant() {
        return this.interpolant;
    }

    public List<Integer> getSimulates() {
        return this.simulates;
    }

    public List<Integer> getSimulators() {
        return this.simulators;
    }

    public int firstEdgeIndex(int e) {
        AutomataEdge edge = new AutomataEdge(e);
        int lb = Collections.binarySearch(this.edges, edge);
        return lb;
    }
}

