/*
 * Decompiled with CFR 0.152.
 */
package fr.lip6.move.gal.structural.tar;

import fr.lip6.move.gal.structural.tar.PlaceRange;
import fr.lip6.move.gal.structural.tar.Range;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class PlaceRangeVector {
    private List<PlaceRange> ranges;

    public PlaceRange find(int place) {
        int index = Collections.binarySearch(this.ranges, new PlaceRange(place));
        if (index < 0) {
            return null;
        }
        return this.ranges.get(index);
    }

    public PlaceRange findOrAdd(int place) {
        int index = Collections.binarySearch(this.ranges, new PlaceRange(place));
        if (index < 0) {
            PlaceRange pr = new PlaceRange(place);
            this.ranges.add(-(index + 1), pr);
            return pr;
        }
        return this.ranges.get(index);
    }

    public int lower(int place) {
        PlaceRange pr = this.find(place);
        if (pr == null) {
            return Integer.MIN_VALUE;
        }
        return pr.getRange().getLower();
    }

    public int upper(int place) {
        PlaceRange pr = this.find(place);
        if (pr == null) {
            return Integer.MAX_VALUE;
        }
        return pr.getRange().getUpper();
    }

    public void compact() {
        this.ranges.removeIf(p -> p.getRange().isUnbound());
    }

    public boolean isCompact() {
        return this.ranges.stream().allMatch(p -> !p.getRange().isUnbound());
    }

    void copy(PlaceRangeVector prv) {
        this.ranges = new ArrayList<PlaceRange>();
        for (PlaceRange pr : prv.ranges) {
            if (pr.getRange().isUnbound()) continue;
            this.ranges.add(pr.copy());
        }
    }

    public int size() {
        return this.ranges.size();
    }

    public String toString() {
        return "{" + String.valueOf(this.ranges) + "}";
    }

    public Range.RangeComparison compare(PlaceRangeVector other) {
        assert (this.isCompact());
        assert (other.isCompact());
        Iterator<PlaceRange> sit = this.ranges.iterator();
        Iterator<PlaceRange> oit = other.ranges.iterator();
        boolean includes = true;
        boolean included = true;
        PlaceRange prsit = null;
        PlaceRange proit = null;
        do {
            if (!sit.hasNext()) {
                included = included && !oit.hasNext();
                break;
            }
            if (!oit.hasNext()) {
                includes = false;
                break;
            }
            if (prsit == null) {
                prsit = sit.next();
            }
            if (proit == null) {
                proit = oit.next();
            }
            if (prsit.getPlace() == proit.getPlace()) {
                Range.RangeComparison r = prsit.getRange().compare(proit.getRange());
                includes &= r.includes;
                included &= r.included;
                prsit = null;
                proit = null;
                continue;
            }
            if (prsit.getPlace() < proit.getPlace()) {
                includes = false;
                prsit = null;
                continue;
            }
            included = false;
            proit = null;
        } while (includes || included);
        return new Range.RangeComparison(includes, included);
    }

    public boolean restricts(List<Integer> writes) {
        int ri = 0;
        for (Integer p : writes) {
            while (ri < this.ranges.size() && (this.ranges.get(ri).getPlace() < p || this.ranges.get(ri).getRange().isUnbound())) {
                ++ri;
            }
            if (ri == this.ranges.size()) break;
            if (this.ranges.get(ri).getPlace() != p.intValue()) continue;
            return true;
        }
        return false;
    }

    public boolean isTrue() {
        return this.ranges.isEmpty();
    }
}

