/*
 * Decompiled with CFR 0.152.
 */
package fr.lip6.move.gal.structural.tar;

public class Range {
    private int lower;
    private int upper;

    public Range() {
        this.lower = Integer.MIN_VALUE;
        this.upper = Integer.MAX_VALUE;
    }

    public Range(int point) {
        this.lower = this.upper = point;
    }

    public Range(int lower, int upper) {
        this.lower = lower;
        this.upper = upper;
    }

    public boolean contains(int val) {
        return this.lower <= val && val <= this.upper;
    }

    public Range copy() {
        return new Range(this.lower, this.upper);
    }

    public void free() {
        this.lower = Integer.MIN_VALUE;
        this.upper = Integer.MAX_VALUE;
    }

    public int getLower() {
        return this.lower;
    }

    public int getUpper() {
        return this.upper;
    }

    public boolean intersects(Range other) {
        return this.lower <= other.upper && other.lower <= this.upper;
    }

    public void intersectWith(Range other) {
        this.lower = Math.max(this.lower, other.lower);
        this.upper = Math.min(this.upper, other.upper);
    }

    public void invalidate() {
        this.lower = 1;
        this.upper = 0;
    }

    public boolean isSound() {
        return this.lower <= this.upper;
    }

    public boolean noLower() {
        return this.lower == Integer.MIN_VALUE;
    }

    public boolean noUpper() {
        return this.upper == Integer.MAX_VALUE;
    }

    public void restrictTo(int value) {
        this.lower = this.upper = value;
    }

    public void shift(int delta) {
        this.lower = delta < 0 && this.lower < Integer.MIN_VALUE - delta ? Integer.MIN_VALUE : (this.lower += delta);
        this.upper = delta > 0 && this.upper >= Integer.MAX_VALUE - delta ? Integer.MAX_VALUE : (this.upper += delta);
    }

    public int size() {
        return 1 + (this.upper - this.lower);
    }

    public String toString() {
        return (String)(this.noLower() ? "[0" : "[" + this.lower) + ", " + (String)(this.noUpper() ? "inf]" : this.upper + "]");
    }

    public boolean isUnbound() {
        return this.noLower() && this.noUpper();
    }

    public void unionToCover(int value) {
        this.lower = Math.min(this.lower, value);
        this.upper = Math.max(this.upper, value);
    }

    public void unionWith(Range other) {
        this.lower = Math.min(this.lower, other.lower);
        this.upper = Math.max(this.upper, other.upper);
    }

    public RangeComparison compare(Range other) {
        return new RangeComparison(this.lower <= other.lower && this.upper >= other.upper, this.lower >= other.lower && this.upper <= other.upper);
    }

    public void setLower(int lower) {
        this.lower = lower;
    }

    public static class RangeComparison {
        public boolean includes;
        public boolean included;

        public RangeComparison(boolean includes, boolean included) {
            this.includes = includes;
            this.included = included;
        }
    }
}

