/*
 * Decompiled with CFR 0.152.
 */
package fr.lip6.move.gal.structural.tar;

import fr.lip6.move.gal.structural.ISparsePetriNet;
import fr.lip6.move.gal.structural.expr.Expression;
import fr.lip6.move.gal.structural.expr.Op;
import fr.lip6.move.gal.structural.tar.PlaceRangeVector;

public class RangeEvalContext {
    private PlaceRangeVector ranges;
    private PlaceRangeVector sufficient = new PlaceRangeVector();
    private ISparsePetriNet net;
    private int[] use_count;
    private boolean bool_result;

    public RangeEvalContext(PlaceRangeVector prv, ISparsePetriNet net, int[] use_count) {
        this.ranges = prv;
        this.net = net;
        this.use_count = use_count;
    }

    public void visit(Expression e) {
        if (e == null) {
            return;
        }
        if (e.getOp() == Op.NOT) {
            throw new IllegalArgumentException("Please push negations before using Range eval context.");
        }
        if (e.getOp() == Op.AND) {
            PlaceRangeVector cursuff = new PlaceRangeVector();
            cursuff.copy(this.sufficient);
            PlaceRangeVector best = new PlaceRangeVector();
            best.copy(this.sufficient);
            boolean found = false;
            int cid = 0;
            int cide = e.nbChildren();
            while (cid < cide) {
                this.visit(e.childAt(cid));
                if (!this.bool_result) {
                    if (!found || this.sufficient.size() < best.size()) {
                        best.copy(this.sufficient);
                    }
                    cursuff.copy(this.sufficient);
                    found = true;
                }
                ++cid;
            }
            if (found) {
                this.sufficient.copy(best);
            } else {
                this.sufficient.copy(cursuff);
            }
            this.bool_result = !found;
        } else if (e.getOp() == Op.OR) {
            PlaceRangeVector tmpsuff = new PlaceRangeVector();
            tmpsuff.copy(this.sufficient);
        }
    }
}

