/*
 * Decompiled with CFR 0.152.
 */
package fr.lip6.move.gal.structural.tar;

import android.util.SparseIntArray;
import fr.lip6.move.gal.structural.ISparsePetriNet;
import fr.lip6.move.gal.structural.Property;
import fr.lip6.move.gal.structural.PropertyType;
import fr.lip6.move.gal.structural.expr.Expression;
import fr.lip6.move.gal.structural.expr.Op;
import fr.lip6.move.gal.structural.tar.PlaceRange;
import fr.lip6.move.gal.structural.tar.PlaceRangeVector;
import fr.lip6.move.gal.structural.tar.RangeEvalContext;
import fr.lip6.move.gal.structural.tar.State;
import fr.lip6.move.gal.structural.tar.TraceSet;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import java.util.Stack;

public class Solver {
    private ISparsePetriNet net;
    private SparseIntArray initial;
    private Property query;
    private BitSet inq;
    private BitSet dirty;
    private SparseIntArray m = new SparseIntArray();
    private SparseIntArray failm = new SparseIntArray();
    private SparseIntArray mark = new SparseIntArray();
    private int[] use_count;

    public Solver(ISparsePetriNet pn, SparseIntArray initial, Property property, BitSet support) {
        this.net = pn;
        this.initial = initial.clone();
        this.query = property;
        this.inq = support;
        this.dirty = new BitSet();
        this.use_count = new int[pn.getPlaceCount()];
        int i = support.nextSetBit(0);
        while (i >= 0) {
            int n = i;
            this.use_count[n] = this.use_count[n] + 1;
            if (i == Integer.MAX_VALUE) break;
            i = support.nextSetBit(i + 1);
        }
        int tid = 0;
        int tide = this.net.getTransitionCount();
        while (tid < tide) {
            SparseIntArray pre = this.net.getFlowPT().getColumn(tid);
            int i2 = 0;
            int ie = pre.size();
            while (i2 < ie) {
                int n = pre.keyAt(i2);
                this.use_count[n] = this.use_count[n] + tide;
                ++i2;
            }
            ++tid;
        }
    }

    public BitSet getSupport() {
        return this.inq;
    }

    public boolean check(Stack<State> trace, TraceSet interpolants) {
        this.dirty.clear();
        this.findFree(trace);
        return false;
    }

    private List<Interpolant> findFree(Stack<State> trace) {
        int step = trace.size() - 2;
        while (step >= 1) {
            ArrayList<Interpolant> inter = new ArrayList<Interpolant>();
            inter.add(new Interpolant());
            inter.add(new Interpolant());
            State s = (State)trace.get(step);
            ((Interpolant)inter.get((int)0)).edges = s.getEdgeCount();
            int t = s.getEdgeCount() - 1;
            SparseIntArray post = this.net.getFlowTP().getColumn(t);
            Interpolant back = (Interpolant)inter.get(inter.size() - 1);
            int i = 0;
            int ie = post.size();
            while (i < ie) {
                int pid = post.keyAt(i);
                if (this.inq.get(pid)) {
                    PlaceRange pr = back.prv.findOrAdd(pid);
                    pr.getRange().setLower(post.valueAt(i));
                }
                ++i;
            }
            back.prv.compact();
            if (!back.prv.isTrue()) {
                int f = step + 1;
                while (f < trace.size()) {
                    State s2 = (State)trace.get(f);
                    int t2 = s2.getEdgeCount();
                    if (t2 == 0) {
                        back = (Interpolant)inter.get(inter.size() - 1);
                        back.edges = 0;
                        RangeEvalContext ctx = new RangeEvalContext(back.prv, this.net, this.use_count);
                        if (this.query.getType() == PropertyType.INVARIANT && this.query.getBody().getOp() == Op.EF) {
                            ctx.visit(this.query.getBody());
                        } else if (this.query.getType() == PropertyType.INVARIANT && this.query.getBody().getOp() == Op.AG) {
                            ctx.visit(Expression.not(this.query.getBody()));
                        } else {
                            throw new IllegalArgumentException("TAR can only be used for INVARIANT formulas currently.");
                        }
                    }
                    ++f;
                }
            }
            --step;
        }
        return null;
    }

    private static class Interpolant {
        PlaceRangeVector prv = new PlaceRangeVector();
        int edges = 0;

        private Interpolant() {
        }
    }
}

