/*
 * Decompiled with CFR 0.152.
 */
package fr.lip6.move.gal.structural.tar;

import fr.lip6.move.gal.structural.ISparsePetriNet;
import java.util.Random;
import java.util.Set;
import java.util.TreeSet;

public class State
implements Comparable<State> {
    private int offset = 0;
    private int size = Integer.MAX_VALUE;
    private int edgeCount = 0;
    private Set<Integer> interpolant = new TreeSet<Integer>();
    private static Random rand = new Random();

    @Override
    public int compareTo(State other) {
        if (this.interpolant.size() < other.interpolant.size() && other.interpolant.containsAll(this.interpolant)) {
            return -1;
        }
        if (this.equals(other)) {
            return 0;
        }
        return 1;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.interpolant == null ? 0 : this.interpolant.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        State other = (State)obj;
        return !(this.interpolant == null ? other.interpolant != null : !this.interpolant.equals(other.interpolant));
    }

    public int getEdgeCount() {
        if (this.edgeCount == 0) {
            return 0;
        }
        return 1 + (this.edgeCount - 1 + this.offset) % this.size;
    }

    public void setEdge(int edge) {
        this.edgeCount = edge;
        this.offset = 0;
    }

    public boolean nextEdge(ISparsePetriNet pn) {
        ++this.edgeCount;
        return this.done(pn);
    }

    public boolean done(ISparsePetriNet pn) {
        return this.edgeCount > pn.getTransitionCount();
    }

    public Set<Integer> getInterpolant() {
        return this.interpolant;
    }

    public void resetEdges(ISparsePetriNet pn) {
        this.size = pn.getTransitionCount();
        this.edgeCount = 0;
        this.offset = rand.nextInt(pn.getTransitionCount());
    }

    public void setInterpolant(Set<Integer> interpolant) {
        this.interpolant = new TreeSet<Integer>(interpolant);
    }
}

