/*
 * Decompiled with CFR 0.152.
 */
package fr.lip6.move.gal.structural.tar;

import android.util.SparseIntArray;
import fr.lip6.move.gal.mcc.properties.DoneProperties;
import fr.lip6.move.gal.structural.ISparsePetriNet;
import fr.lip6.move.gal.structural.PetriNet;
import fr.lip6.move.gal.structural.Property;
import fr.lip6.move.gal.structural.tar.AntiChain;
import fr.lip6.move.gal.structural.tar.Solver;
import fr.lip6.move.gal.structural.tar.State;
import fr.lip6.move.gal.structural.tar.TraceSet;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.Stack;

public class TARReachabilitySearch {
    private static final int DEBUG = 0;
    private int kbound;
    private int stepno = 0;
    private ISparsePetriNet pn;
    private TraceSet traceSet;

    public TARReachabilitySearch(ISparsePetriNet pn, int kbound) {
        this.pn = pn;
        this.kbound = kbound;
    }

    public void check(DoneProperties doneProps) {
    }

    private void handleInvalidTrace(List<State> waiting, int nvalid) {
        assert (waiting.size() >= nvalid);
        waiting = waiting.subList(0, nvalid);
        int i = 1;
        while (i < waiting.size()) {
            boolean brk = false;
            int j = 0;
            while (j < i) {
                if (waiting.get(j).compareTo(waiting.get(i)) < 0) {
                    waiting = waiting.subList(0, i);
                    brk = true;
                    break;
                }
                ++j;
            }
            if (brk) break;
            if (this.doStep(waiting.get(i - 1), waiting.get(i).getInterpolant())) {
                if (i == 1) break;
                waiting = waiting.subList(0, i - 1);
                break;
            }
            ++i;
        }
    }

    private boolean doStep(State state, Set<Integer> nextinter) {
        if (this.traceSet.follow(state.getInterpolant(), nextinter, state.getEdgeCount())) {
            return true;
        }
        if (state.getEdgeCount() == 0) {
            return false;
        }
        this.addNonChanging(state, state.getInterpolant(), nextinter);
        this.traceSet.maximize(nextinter);
        return false;
    }

    private void addNonChanging(State state, Set<Integer> maximal, Set<Integer> nextinter) {
        ArrayList<Integer> changes = new ArrayList<Integer>();
        SparseIntArray pre = this.pn.getFlowPT().getColumn(state.getEdgeCount() - 1);
        SparseIntArray post = this.pn.getFlowTP().getColumn(state.getEdgeCount() - 1);
        int i = 0;
        while (i < pre.size()) {
            changes.add(pre.keyAt(i));
            ++i;
        }
        i = 0;
        while (i < post.size()) {
            changes.add(post.keyAt(i));
            ++i;
        }
        changes.sort(Comparator.naturalOrder());
        this.traceSet.copyNonChanged(maximal, changes, nextinter);
    }

    public void reachable(List<Property> queries, List<Optional<Boolean>> results, boolean printstats, boolean printtrace) {
        SparseIntArray state = new SparseIntArray(this.pn.getMarks());
        int i = 0;
        while (i < queries.size()) {
            this.traceSet.clear();
            if (results.get(i).isEmpty()) {
                BitSet support = new BitSet();
                PetriNet.addSupport(queries.get(i).getBody(), support);
                Solver solver = new Solver(this.pn, state, queries.get(i), support);
                boolean res = this.tryReach(printtrace, solver);
                results.set(i, Optional.of(res));
            }
            ++i;
        }
        if (printstats) {
            this.printStats();
        }
    }

    private void printStats() {
    }

    private boolean update_use(boolean[] use_trans, SparseIntArray use_place, boolean any) {
        SparseIntArray np = use_place.clone();
        boolean update = false;
        int t = 0;
        while (t < this.pn.getTransitionCount()) {
            SparseIntArray pre = this.pn.getFlowPT().getColumn(t);
            SparseIntArray post = this.pn.getFlowTP().getColumn(t);
            if (!use_trans[t + 1]) {
                if (SparseIntArray.keysIntersect(pre, np) || SparseIntArray.keysIntersect(post, np)) {
                    use_trans[t + 1] = true;
                }
                if (use_trans[t + 1]) {
                    update = true;
                    int i = pre.size() - 1;
                    while (i >= 0) {
                        np.put(i, 1);
                        --i;
                    }
                    if (any) {
                        use_place.move(np);
                        return true;
                    }
                }
            }
            ++t;
        }
        use_place.move(np);
        return update;
    }

    private boolean tryReach(boolean printtrace, Solver solver) {
        TARResult res;
        block3: {
            this.traceSet.removeEdges(0);
            boolean[] use_trans = new boolean[this.pn.getTransitionCount()];
            BitSet support = solver.getSupport();
            SparseIntArray use_place = new SparseIntArray();
            int i = support.nextSetBit(0);
            while (i >= 0) {
                use_place.append(i, 1);
                if (i == Integer.MAX_VALUE) break;
                i = support.nextSetBit(i + 1);
            }
            use_trans[0] = true;
            this.update_use(use_trans, use_place, false);
            while (true) {
                res = this.runTAR(printtrace, solver, use_trans);
                if (!res.finished) continue;
                if (res.satisfied) break block3;
                if (!this.update_use(use_trans, use_place, false)) break;
            }
            if (printtrace) {
                System.err.println(this.traceSet.toString());
            }
        }
        return res.satisfied;
    }

    private TARResult runTAR(boolean printtrace, Solver solver, boolean[] use_trans) {
        System.currentTimeMillis();
        AntiChain checked = new AntiChain();
        boolean all_covered = true;
        Stack<State> waiting = new Stack<State>();
        State state = new State();
        state.resetEdges(this.pn);
        HashSet<Integer> init = new HashSet<Integer>(this.traceSet.getInitial());
        this.traceSet.maximize(init);
        state.setInterpolant(init);
        waiting.add(state);
        while (!waiting.empty()) {
            if (this.popDone(waiting)) continue;
            ++this.stepno;
            assert (waiting.size() > 0);
            state = waiting.peek();
            HashSet<Integer> nextinter = new HashSet<Integer>();
            if (!use_trans[state.getEdgeCount()]) {
                state.nextEdge(this.pn);
                continue;
            }
            if (this.doStep(state, nextinter)) {
                state.nextEdge(this.pn);
                continue;
            }
            if (waiting.peek().getEdgeCount() == 0) {
                boolean satisfied = solver.check(waiting, this.traceSet);
                if (satisfied) {
                    if (printtrace) {
                        this.printTrace(waiting);
                    }
                    return new TARResult(true, true);
                }
                return new TARResult(false, false);
            }
            this.nextEdge(checked, state, waiting, nextinter);
        }
        return new TARResult(all_covered, false);
    }

    private void nextEdge(AntiChain checked, State state, Stack<State> waiting, Set<Integer> nextinter) {
    }

    private void printTrace(Stack<State> waiting) {
    }

    private boolean popDone(Stack<State> waiting) {
        boolean popped = false;
        while (((State)waiting.get(waiting.size() - 1)).done(this.pn)) {
            assert (waiting.size() > 0);
            waiting.pop();
            popped = true;
            if (waiting.size() > 0) {
                waiting.peek().nextEdge(this.pn);
            }
            if (waiting.size() == 0) break;
        }
        return popped;
    }

    private static class TARResult {
        public boolean finished;
        public boolean satisfied;

        public TARResult(boolean finished, boolean satisfied) {
            this.finished = finished;
            this.satisfied = satisfied;
        }
    }
}

