/*
 * Decompiled with CFR 0.152.
 */
package fr.lip6.move.gal.structural.tar;

import fr.lip6.move.gal.structural.ISparsePetriNet;
import fr.lip6.move.gal.structural.tar.AutomataEdge;
import fr.lip6.move.gal.structural.tar.AutomataState;
import fr.lip6.move.gal.structural.tar.PlaceRangeVector;
import fr.lip6.move.gal.structural.tar.Range;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class TraceSet {
    private ISparsePetriNet pn;
    private Map<PlaceRangeVector, Integer> indexMap;
    private List<AutomataState> states;
    private Set<Integer> initial;

    public TraceSet(ISparsePetriNet pn) {
        this.pn = pn;
        this.init();
    }

    public void init() {
        PlaceRangeVector trueRange = new PlaceRangeVector();
        PlaceRangeVector falseRange = new PlaceRangeVector();
        int pid = 0;
        int pide = this.pn.getPlaceCount();
        while (pid < pide) {
            falseRange.findOrAdd(pid).getRange().restrictTo(0);
            ++pid;
        }
        this.states.add(new AutomataState(falseRange));
        this.states.add(new AutomataState(trueRange));
        this.computeSimulation(0);
    }

    private void computeSimulation(int index) {
        AutomataState state = this.states.get(index);
        assert (index == this.states.size() - 1 || index == 0);
        int i = 0;
        while (i < this.states.size()) {
            if (i != index) {
                int pos;
                AutomataState other = this.states.get(i);
                Range.RangeComparison res = other.getInterpolant().compare(state.getInterpolant());
                assert (!res.includes || !res.included);
                if (res.includes) {
                    state.getSimulates().add(i);
                    pos = Collections.binarySearch(other.getSimulators(), index);
                    if (pos < 0) {
                        other.getSimulators().add(-(pos + 1), index);
                    }
                }
                if (res.included) {
                    state.getSimulators().add(i);
                    pos = Collections.binarySearch(other.getSimulates(), index);
                    if (pos < 0) {
                        other.getSimulates().add(-(pos + 1), index);
                    }
                }
            }
            ++i;
        }
    }

    public boolean follow(Set<Integer> from, Set<Integer> nextinter, int symbol) {
        nextinter.add(1);
        block0: for (Integer ii : from) {
            int i = ii;
            if (i == 0) {
                assert (false);
                continue;
            }
            AutomataState as = this.states.get(i);
            if (as.isAccept()) {
                assert (false);
                break;
            }
            int it = as.firstEdgeIndex(symbol);
            while (it > 0 && it < as.getEdges().size()) {
                AutomataEdge ae = as.getEdges().get(it);
                if (ae.getEdge() != symbol) continue block0;
                ++it;
                assert (ae.getTo().size() > 0);
                if (ae.getTo().contains(0)) {
                    return true;
                }
                nextinter.addAll(ae.getTo());
            }
        }
        return false;
    }

    public void copyNonChanged(Set<Integer> from, List<Integer> modifiers, Set<Integer> to) {
        for (Integer p : from) {
            if (this.states.get(p).getInterpolant().restricts(modifiers)) continue;
            to.add(p);
        }
    }

    public void maximize(Set<Integer> org) {
        for (Integer i : new ArrayList<Integer>(org)) {
            org.addAll(this.states.get(i).getSimulates());
        }
        org.add(1);
    }

    public void clear() {
        this.initial.clear();
        this.indexMap.clear();
        this.states.clear();
        this.init();
    }

    public void removeEdges(int edge) {
        for (AutomataState s : this.states) {
            s.removeEdge(edge);
        }
    }

    public Set<Integer> getInitial() {
        return this.initial;
    }
}

