/*
 * Decompiled with CFR 0.152.
 */
package fr.lip6.move.gal.util;

import android.util.SparseIntArray;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;

public class IntMatrixCol {
    private int iRows;
    private int iCols;
    private final List<SparseIntArray> lCols;

    public static IntMatrixCol identity(int rows, int cols) {
        IntMatrixCol result = new IntMatrixCol(rows, cols);
        int i = 0;
        while (i < rows && i < cols) {
            result.set(i, i, 1);
            ++i;
        }
        return result;
    }

    public IntMatrixCol(int rows, int cols) {
        this.iRows = rows;
        this.iCols = cols;
        this.lCols = new ArrayList<SparseIntArray>(this.iCols);
        int col = 0;
        while (col < this.iCols) {
            SparseIntArray toadd = new SparseIntArray();
            this.lCols.add(toadd);
            ++col;
        }
    }

    public IntMatrixCol(IntMatrixCol ori) {
        this.iRows = ori.iRows;
        this.iCols = ori.iCols;
        this.lCols = new ArrayList<SparseIntArray>(this.iCols);
        for (SparseIntArray a : ori.lCols) {
            this.lCols.add(a.clone());
        }
    }

    public IntMatrixCol(int[][] src) {
        this.iRows = src.length;
        this.iCols = src[0].length;
        this.lCols = new ArrayList<SparseIntArray>(this.iCols);
        int col = 0;
        while (col < this.iCols) {
            SparseIntArray toadd = new SparseIntArray();
            int row = 0;
            while (row < this.iRows) {
                int val = src[row][col];
                if (val != 0) {
                    toadd.put(row, val);
                }
                ++row;
            }
            this.lCols.add(toadd);
            ++col;
        }
    }

    public int[][] explicit() {
        int[][] mat = new int[this.iRows][this.iCols];
        int col = 0;
        while (col < this.iCols) {
            SparseIntArray arr = this.lCols.get(col);
            int i = 0;
            while (i < arr.size()) {
                int val;
                int row = arr.keyAt(i);
                mat[row][col] = val = arr.valueAt(i);
                ++i;
            }
            ++col;
        }
        return mat;
    }

    public int getRowCount() {
        return this.iRows;
    }

    public void addRow() {
        ++this.iRows;
    }

    public int getColumnCount() {
        return this.iCols;
    }

    public SparseIntArray getColumn(int i) {
        return this.lCols.get(i);
    }

    public SparseIntArray setColumn(int i, SparseIntArray v) {
        return this.lCols.set(i, v);
    }

    public int get(int row, int col) {
        return this.lCols.get(col).get(row, 0);
    }

    public void set(int row, int col, int val) {
        if (row < 0 || col < 0 || row >= this.iRows || col >= this.iCols) {
            throw new IllegalArgumentException();
        }
        if (val != 0) {
            SparseIntArray column = this.lCols.get(col);
            if (column.size() == 0 || column.keyAt(column.size() - 1) < row) {
                column.append(row, val);
            } else {
                column.put(row, val);
            }
        } else {
            this.lCols.get(col).delete(row);
        }
    }

    public int[] getNoneZeroRow() {
        int tcol = 0;
        while (tcol < this.getColumnCount()) {
            if (this.lCols.get(tcol).size() != 0) {
                return new int[]{this.lCols.get(tcol).keyAt(0), tcol};
            }
            ++tcol;
        }
        return null;
    }

    public void deleteColumn(int j) {
        this.lCols.remove(j);
        --this.iCols;
    }

    public void appendColumn(SparseIntArray column) {
        assert (column.size() == 0 || this.iRows > column.keyAt(column.size() - 1));
        this.lCols.add(column);
        ++this.iCols;
    }

    public boolean isZero() {
        for (SparseIntArray row : this.lCols) {
            if (row.size() == 0) continue;
            return false;
        }
        return true;
    }

    public IntMatrixCol transpose() {
        IntMatrixCol tr = new IntMatrixCol(this.iCols, this.iRows);
        this.transposeTo(tr, false);
        return tr;
    }

    public void transposeTo(IntMatrixCol tr) {
        this.transposeTo(tr, true);
    }

    public void transposeTo(IntMatrixCol tr, boolean clear) {
        if (clear) {
            tr.clear(this.getColumnCount(), this.getRowCount());
        }
        int tcol = 0;
        while (tcol < this.iCols) {
            SparseIntArray col = this.lCols.get(tcol);
            int k = 0;
            while (k < col.size()) {
                int trow = col.keyAt(k);
                int val = col.valueAt(k);
                tr.set(tcol, trow, val);
                ++k;
            }
            ++tcol;
        }
    }

    public String toString() {
        return "Matrix{lCols=" + String.valueOf(this.lCols) + "}";
    }

    public List<SparseIntArray> getColumns() {
        return this.lCols;
    }

    public void clear(int rowCount, int colCount) {
        int missing = colCount - this.lCols.size();
        if (missing > 0) {
            i = 0;
            while (i < missing) {
                this.lCols.add(new SparseIntArray());
                ++i;
            }
        } else {
            i = 0;
            while (i < missing) {
                this.lCols.remove(this.lCols.size() - 1);
                ++i;
            }
        }
        this.iCols = colCount;
        this.iRows = rowCount;
        for (SparseIntArray s : this.lCols) {
            s.clear();
        }
    }

    public void deleteRow(int row) {
        for (SparseIntArray col : this.getColumns()) {
            col.deleteAndShift(row);
        }
        --this.iRows;
    }

    public void deleteRows(List<Integer> todel) {
        if (this.getColumnCount() >= 1000) {
            ((Stream)this.getColumns().parallelStream().unordered()).forEach(col -> col.deleteAndShift(todel));
        } else {
            ((Stream)this.getColumns().stream().unordered()).forEach(col -> col.deleteAndShift(todel));
        }
        this.iRows -= todel.size();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        IntMatrixCol other = (IntMatrixCol)obj;
        if (this.iCols != other.iCols) {
            return false;
        }
        if (this.iRows != other.iRows) {
            return false;
        }
        return !(this.lCols == null ? other.lCols != null : !this.lCols.equals(other.lCols));
    }

    public static IntMatrixCol sumProd(int alpha, IntMatrixCol ta, int beta, IntMatrixCol tb) {
        if (ta.getColumnCount() != tb.getColumnCount() || ta.getRowCount() != tb.getRowCount()) {
            throw new IllegalArgumentException("Matrices should be homogeneous dimensions for sum-product operation.");
        }
        IntMatrixCol mat = new IntMatrixCol(ta.getRowCount(), ta.getColumnCount());
        int col = 0;
        int cole = ta.getColumnCount();
        while (col < cole) {
            mat.setColumn(col, SparseIntArray.sumProd(alpha, ta.getColumn(col), beta, tb.getColumn(col)));
            ++col;
        }
        return mat;
    }

    public int findMax() {
        int max = 0;
        int ti = 0;
        int tie = this.getColumnCount();
        while (ti < tie) {
            SparseIntArray trcol = this.getColumn(ti);
            int i = 0;
            int ie = trcol.size();
            while (i < ie) {
                max = Math.max(max, trcol.valueAt(i));
                ++i;
            }
            ++ti;
        }
        return max;
    }
}

