/*
 * Decompiled with CFR 0.152.
 */
package fr.lip6.move.gal.util;

import android.util.SparseArray;
import java.util.ArrayList;
import java.util.List;

public class MatrixCol<T> {
    private int iRows;
    private int iCols;
    private final List<SparseArray<T>> lCols;

    public MatrixCol(int rows, int cols) {
        this.iRows = rows;
        this.iCols = cols;
        this.lCols = new ArrayList<SparseArray<T>>(this.iCols);
        int col = 0;
        while (col < this.iCols) {
            this.lCols.add(new SparseArray());
            ++col;
        }
    }

    public MatrixCol(MatrixCol<T> ori) {
        this.iRows = ori.iRows;
        this.iCols = ori.iCols;
        this.lCols = new ArrayList<SparseArray<T>>(this.iCols);
        for (SparseArray<T> a : ori.lCols) {
            this.lCols.add((SparseArray<T>)a.clone());
        }
    }

    public MatrixCol(T[][] src) {
        this.iRows = src.length;
        this.iCols = src[0].length;
        this.lCols = new ArrayList<SparseArray<T>>(this.iCols);
        int col = 0;
        while (col < this.iCols) {
            SparseArray<T> toadd = new SparseArray<T>();
            int row = 0;
            while (row < this.iRows) {
                T val = src[row][col];
                if (val != null) {
                    toadd.put(row, val);
                }
                ++row;
            }
            this.lCols.add(toadd);
            ++col;
        }
    }

    public T[][] explicit() {
        Object[][] mat = new Object[this.iRows][this.iCols];
        int col = 0;
        while (col < this.iCols) {
            SparseArray<T> arr = this.lCols.get(col);
            int i = 0;
            while (i < arr.size()) {
                int row = arr.keyAt(i);
                T val = arr.valueAt(i);
                mat[row][col] = val;
                ++i;
            }
            ++col;
        }
        return mat;
    }

    public int getRowCount() {
        return this.iRows;
    }

    public void addRow() {
        ++this.iRows;
    }

    public int getColumnCount() {
        return this.iCols;
    }

    public SparseArray<T> getColumn(int i) {
        return this.lCols.get(i);
    }

    public SparseArray<T> setColumn(int i, SparseArray<T> v) {
        return this.lCols.set(i, v);
    }

    public T get(int row, int col) {
        return this.lCols.get(col).get(row);
    }

    public void set(int row, int col, T val) {
        if (row < 0 || col < 0 || row >= this.iRows || col >= this.iCols) {
            throw new IllegalArgumentException();
        }
        if (val != null) {
            SparseArray<T> column = this.lCols.get(col);
            if (column.size() == 0 || column.keyAt(column.size() - 1) < row) {
                column.append(row, val);
            } else {
                column.put(row, val);
            }
        } else {
            this.lCols.get(col).delete(row);
        }
    }

    public int[] getNoneZeroRow() {
        int tcol = 0;
        while (tcol < this.getColumnCount()) {
            if (this.lCols.get(tcol).size() != 0) {
                return new int[]{this.lCols.get(tcol).keyAt(0), tcol};
            }
            ++tcol;
        }
        return null;
    }

    public void deleteColumn(int j) {
        this.lCols.remove(j);
        --this.iCols;
    }

    public void appendColumn(SparseArray<T> column) {
        assert (column.size() == 0 || this.iRows > column.keyAt(column.size() - 1));
        this.lCols.add(column);
        ++this.iCols;
    }

    public boolean isZero() {
        for (SparseArray<T> row : this.lCols) {
            if (row.size() == 0) continue;
            return false;
        }
        return true;
    }

    public MatrixCol<T> transpose() {
        MatrixCol<T> tr = new MatrixCol<T>(this.iCols, this.iRows);
        this.transposeTo(tr, false);
        return tr;
    }

    public void transposeTo(MatrixCol<T> tr) {
        this.transposeTo(tr, true);
    }

    public void transposeTo(MatrixCol<T> tr, boolean clear) {
        if (clear) {
            tr.clear(this.getColumnCount(), this.getRowCount());
        }
        int tcol = 0;
        while (tcol < this.iCols) {
            SparseArray<T> col = this.lCols.get(tcol);
            int k = 0;
            while (k < col.size()) {
                int trow = col.keyAt(k);
                T val = col.valueAt(k);
                tr.set(tcol, trow, val);
                ++k;
            }
            ++tcol;
        }
    }

    public String toString() {
        return "Matrix{lCols=" + String.valueOf(this.lCols) + "}";
    }

    public List<SparseArray<T>> getColumns() {
        return this.lCols;
    }

    public void clear(int rowCount, int colCount) {
        int missing = colCount - this.lCols.size();
        if (missing > 0) {
            i = 0;
            while (i < missing) {
                this.lCols.add(new SparseArray());
                ++i;
            }
        } else {
            i = 0;
            while (i < missing) {
                this.lCols.remove(this.lCols.size() - 1);
                ++i;
            }
        }
        this.iCols = colCount;
        this.iRows = rowCount;
        for (SparseArray<T> s : this.lCols) {
            s.clear();
        }
    }

    public void deleteRow(int row) {
        for (SparseArray<T> col : this.getColumns()) {
            col.deleteAndShift(row);
        }
        --this.iRows;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MatrixCol other = (MatrixCol)obj;
        if (this.iCols != other.iCols) {
            return false;
        }
        if (this.iRows != other.iRows) {
            return false;
        }
        return !(this.lCols == null ? other.lCols != null : !this.lCols.equals(other.lCols));
    }
}

