/*
 * Decompiled with CFR 0.152.
 */
package uniol.apt.analysis.invariants;

import android.util.SparseBoolArray;
import android.util.SparseIntArray;
import fr.lip6.move.gal.structural.FlowMatrix;
import fr.lip6.move.gal.util.IntMatrixCol;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import uniol.apt.analysis.invariants.MathTools;

public class InvariantCalculator {
    static final boolean DEBUG = false;

    private InvariantCalculator() {
    }

    private static List<PpPm> calcPpPm(IntMatrixCol matC) {
        ArrayList<PpPm> result = new ArrayList<PpPm>();
        int row = 0;
        while (row < matC.getRowCount()) {
            result.add(new PpPm(row));
            ++row;
        }
        int icol = 0;
        int cole = matC.getColumnCount();
        while (icol < cole) {
            SparseIntArray col = matC.getColumn(icol);
            int i = 0;
            int ie = col.size();
            while (i < ie) {
                PpPm toedit = (PpPm)result.get(col.keyAt(i));
                if (col.valueAt(i) < 0) {
                    toedit.pMinus.append(icol, true);
                } else {
                    toedit.pPlus.append(icol, true);
                }
                ++i;
            }
            ++icol;
        }
        return result;
    }

    private static Check11bResult check11b(List<PpPm> pppms, int startIndex) {
        Check11bResult res;
        for (PpPm pppm : pppms.subList(startIndex, pppms.size())) {
            res = InvariantCalculator.check11bPppm(pppm);
            if (res == null) continue;
            return res;
        }
        for (PpPm pppm : pppms.subList(0, startIndex)) {
            res = InvariantCalculator.check11bPppm(pppm);
            if (res == null) continue;
            return res;
        }
        return null;
    }

    private static Check11bResult check11bPppm(PpPm pppm) {
        if (pppm.pMinus.size() == 1) {
            return new Check11bResult(pppm.pMinus.keyAt(0), pppm.row, pppm.pPlus);
        }
        if (pppm.pPlus.size() == 1) {
            return new Check11bResult(pppm.pPlus.keyAt(0), pppm.row, pppm.pMinus);
        }
        return null;
    }

    public static Set<SparseIntArray> calcInvariantsPIPE(IntMatrixCol mat, boolean onlyPositive) {
        if (mat.getColumnCount() == 0 || mat.getRowCount() == 0) {
            return new HashSet<SparseIntArray>();
        }
        IntMatrixCol tmat = mat.transpose();
        HashSet<SparseIntArray> normed = new HashSet<SparseIntArray>();
        int i = 0;
        while (i < tmat.getColumnCount()) {
            SparseIntArray norm = tmat.getColumn(i);
            InvariantCalculator.normalize(norm);
            normed.add(norm);
            ++i;
        }
        if (normed.size() < tmat.getColumnCount()) {
            System.out.println("Normalized transition count is " + normed.size() + " out of " + tmat.getColumnCount() + " initially.");
        }
        IntMatrixCol matnorm = new IntMatrixCol(tmat.getRowCount(), 0);
        for (SparseIntArray col : normed) {
            matnorm.appendColumn(col);
        }
        IntMatrixCol matB = InvariantCalculator.phase1PIPE(matnorm.transpose());
        HashSet<SparseIntArray> colsBsparse = new HashSet<SparseIntArray>(2 * matB.getColumnCount());
        int i2 = 0;
        while (i2 < matB.getColumnCount()) {
            SparseIntArray col = matB.getColumn(i2);
            if (col.size() != 0) {
                InvariantCalculator.normalizeWithSign(col);
                colsBsparse.add(col);
            }
            ++i2;
        }
        if (!onlyPositive) {
            return colsBsparse;
        }
        IntMatrixCol colsB = new IntMatrixCol(tmat.getRowCount(), 0);
        for (SparseIntArray cb : colsBsparse) {
            colsB.appendColumn(cb);
        }
        System.out.println("// Phase 2 : computing semi flows from basis of " + colsB.getColumnCount() + " invariants ");
        SparseBoolArray treated = new SparseBoolArray();
        colsBsparse = new HashSet();
        while (colsB.getColumnCount() < 20000) {
            int targetRow;
            if (treated.size() > 0) {
                int i3 = treated.size() - 1;
                while (i3 >= 0) {
                    colsBsparse.add(colsB.getColumn(treated.keyAt(i3)));
                    colsB.deleteColumn(treated.keyAt(i3));
                    --i3;
                }
                treated.clear();
            }
            List<PpPm> pppms = InvariantCalculator.calcPpPm(colsB);
            SparseBoolArray negRows = new SparseBoolArray();
            int minRow = -1;
            int minRowWeight = -1;
            int row = 0;
            int rowe = pppms.size();
            while (row < rowe) {
                PpPm pp = pppms.get(row);
                int pps = pp.pPlus.size();
                int ppm = pp.pMinus.size();
                int weight = pps + ppm;
                if (pps == 0) {
                    int i4 = 0;
                    while (i4 < ppm) {
                        negRows.set(pp.pMinus.keyAt(i4));
                        ++i4;
                    }
                }
                if (pps > 0 && ppm > 0) {
                    if (pps == 1 || ppm == 1) {
                        minRow = row;
                        break;
                    }
                    if (minRow == -1 || minRowWeight > weight) {
                        int refinedweight = 0;
                        int i5 = 0;
                        int ie = pp.pPlus.size();
                        while (i5 < ie) {
                            refinedweight += colsB.getColumn(pp.pPlus.keyAt(i5)).size();
                            ++i5;
                        }
                        i5 = 0;
                        ie = pp.pMinus.size();
                        while (i5 < ie) {
                            refinedweight += colsB.getColumn(pp.pMinus.keyAt(i5)).size();
                            ++i5;
                        }
                        if (minRow == -1 || minRowWeight > refinedweight) {
                            minRow = row;
                            minRowWeight = refinedweight;
                        }
                    }
                }
                ++row;
            }
            if (negRows.size() > 0) {
                int j = negRows.size() - 1;
                while (j >= 0) {
                    colsB.deleteColumn(negRows.keyAt(j));
                    --j;
                }
                continue;
            }
            int purePos = -1;
            int i6 = 0;
            int ie = colsB.getColumnCount();
            while (i6 < ie) {
                if (!treated.get(i6)) {
                    SparseIntArray col = colsB.getColumn(i6);
                    boolean hasNeg = false;
                    int j = 0;
                    int je = col.size();
                    while (j < je) {
                        if (col.valueAt(j) < 0) {
                            hasNeg = true;
                            break;
                        }
                        ++j;
                    }
                    if (!hasNeg) {
                        boolean needed = false;
                        int j2 = 0;
                        int je2 = col.size();
                        while (j2 < je2) {
                            int row2 = col.keyAt(j2);
                            PpPm ppm = pppms.get(row2);
                            if (ppm.pMinus.size() > 0) {
                                needed = true;
                                purePos = i6;
                                minRow = row2;
                                break;
                            }
                            ++j2;
                        }
                        if (needed) break;
                        treated.set(i6);
                    }
                }
                ++i6;
            }
            if ((targetRow = minRow) == -1) break;
            PpPm ppm = pppms.get(targetRow);
            if (ppm.pPlus.size() <= 0) continue;
            int j = 0;
            int je = ppm.pPlus.size();
            while (j < je) {
                SparseIntArray colj = colsB.getColumn(ppm.pPlus.keyAt(j));
                if (purePos != -1) {
                    colj = colsB.getColumn(purePos);
                    j = je;
                }
                int k = 0;
                int ke = ppm.pMinus.size();
                while (k < ke) {
                    SparseIntArray colk = colsB.getColumn(ppm.pMinus.keyAt(k));
                    int a2 = -colk.get(targetRow);
                    int b = colj.get(targetRow);
                    SparseIntArray column = SparseIntArray.sumProd(a2, colj, b, colk);
                    InvariantCalculator.normalize(column);
                    if (column.size() > 0) {
                        colsB.appendColumn(column);
                    }
                    ++k;
                }
                ++j;
            }
            j = ppm.pMinus.size() - 1;
            while (j >= 0) {
                colsB.deleteColumn(ppm.pMinus.keyAt(j));
                treated.deleteAndShift(ppm.pMinus.keyAt(j));
                --j;
            }
        }
        for (SparseIntArray l : colsB.getColumns()) {
            if (l.size() <= 0) continue;
            colsBsparse.add(l);
        }
        colsBsparse.removeIf(a -> {
            int i = 0;
            int ie = a.size();
            while (i < ie) {
                if (a.valueAt(i) < 0) {
                    return true;
                }
                ++i;
            }
            return false;
        });
        System.out.println("Found " + colsBsparse.size() + " positive invariants.");
        return colsBsparse;
    }

    private static List<Integer> normalize(SparseIntArray col, int size) {
        ArrayList<Integer> list = new ArrayList<Integer>(size);
        boolean allneg = true;
        int i = 0;
        while (i < col.size()) {
            if (col.valueAt(i) > 0) {
                allneg = false;
                break;
            }
            ++i;
        }
        if (allneg) {
            i = 0;
            while (i < col.size()) {
                col.setValueAt(i, -col.valueAt(i));
                ++i;
            }
        }
        i = 0;
        while (i < size) {
            list.add(col.get(i, 0));
            ++i;
        }
        InvariantCalculator.normalize(list);
        return list;
    }

    private static IntMatrixCol phase1PIPE(IntMatrixCol matC) {
        IntMatrixCol matB = IntMatrixCol.identity(matC.getColumnCount(), matC.getColumnCount());
        System.out.println("// Phase 1: matrix " + matC.getRowCount() + " rows " + matC.getColumnCount() + " cols");
        List<PpPm> pppms = InvariantCalculator.calcPpPm(matC);
        int startIndex = 0;
        while (!matC.isZero()) {
            startIndex = InvariantCalculator.test1b(matC, matB, pppms, startIndex);
        }
        return matB;
    }

    private static int test1b(IntMatrixCol matC, IntMatrixCol matB, List<PpPm> pppms, int startIndex) {
        Check11bResult chkResult = InvariantCalculator.check11b(pppms, startIndex);
        if (chkResult != null) {
            InvariantCalculator.test1b1(matC, matB, pppms, chkResult);
            startIndex = chkResult.row;
        } else {
            InvariantCalculator.test1b2(matC, matB, pppms);
        }
        return startIndex;
    }

    public static SparseBoolArray sumProdInto(int alpha, SparseIntArray ta, int beta, SparseIntArray tb) throws ArithmeticException {
        SparseBoolArray changed = new SparseBoolArray();
        SparseIntArray flow = new SparseIntArray(Math.max(ta.size(), tb.size()));
        int i = 0;
        int j = 0;
        while (i < ta.size() || j < tb.size()) {
            int val;
            int kj;
            int ki = i == ta.size() ? Integer.MAX_VALUE : ta.keyAt(i);
            int n = kj = j == tb.size() ? Integer.MAX_VALUE : tb.keyAt(j);
            if (ki == kj) {
                val = Math.addExact(Math.multiplyExact(alpha, ta.valueAt(i)), Math.multiplyExact(beta, tb.valueAt(j)));
                if (val != 0) {
                    flow.append(ki, val);
                }
                if (val != ta.valueAt(i)) {
                    changed.set(ki);
                }
                ++i;
                ++j;
                continue;
            }
            if (ki < kj) {
                val = Math.multiplyExact(alpha, ta.valueAt(i));
                if (val != 0) {
                    flow.append(ki, val);
                }
                if (val != ta.valueAt(i)) {
                    changed.set(ki);
                }
                ++i;
                continue;
            }
            if (kj >= ki) continue;
            val = Math.multiplyExact(beta, tb.valueAt(j));
            if (val != 0) {
                flow.append(kj, val);
            }
            if (val != 0) {
                changed.set(kj);
            }
            ++j;
        }
        ta.move(flow);
        return changed;
    }

    private static void test1b2(IntMatrixCol matC, IntMatrixCol matB, List<PpPm> pppms) {
        int candidate = -1;
        int szcand = Integer.MAX_VALUE;
        int totalcand = Integer.MAX_VALUE;
        int col = 0;
        while (col < matC.getColumnCount()) {
            int size = matC.getColumn(col).size();
            if (size != 0 && size <= szcand) {
                int total = InvariantCalculator.sumAbsValues(matC.getColumn(col));
                if (size < szcand || size == szcand && total <= totalcand) {
                    candidate = col;
                    szcand = size;
                    totalcand = total;
                }
            }
            ++col;
        }
        int tRow = matC.getColumn(candidate).keyAt(0);
        int tCol = candidate;
        int cHk = matC.get(tRow, tCol);
        int bbeta = Math.abs(cHk);
        PpPm rowppm = pppms.get(tRow);
        SparseBoolArray toVisit = SparseBoolArray.or(rowppm.pMinus, rowppm.pPlus);
        int i = 0;
        while (i < toVisit.size()) {
            int cHj;
            int j = toVisit.keyAt(i);
            SparseIntArray colj = matC.getColumn(j);
            if (j != tCol && (cHj = colj.get(tRow)) != 0) {
                int alpha;
                int n = alpha = Math.signum(cHj) * Math.signum(cHk) < 0.0f ? Math.abs(cHj) : -Math.abs(cHj);
                if (alpha != 0 || bbeta != 1) {
                    int gcd = MathTools.gcd(alpha, bbeta);
                    int beta = bbeta / gcd;
                    SparseBoolArray changed = InvariantCalculator.sumProdInto(beta, colj, alpha /= gcd, matC.getColumn(tCol));
                    int ind = 0;
                    int inde = changed.size();
                    while (ind < inde) {
                        pppms.get(changed.keyAt(ind)).setValue(j, colj.get(changed.keyAt(ind)));
                        ++ind;
                    }
                    SparseIntArray coljb = matB.getColumn(j);
                    InvariantCalculator.sumProdInto(beta, coljb, alpha, matB.getColumn(tCol));
                }
            }
            ++i;
        }
        InvariantCalculator.clearColumn(tCol, matC, matB, pppms);
    }

    public static void clearColumn(int tCol, IntMatrixCol matC, IntMatrixCol matB, List<PpPm> pppms) {
        SparseIntArray colk = matC.getColumn(tCol);
        int i = 0;
        int ie = colk.size();
        while (i < ie) {
            pppms.get(colk.keyAt(i)).setValue(tCol, 0);
            ++i;
        }
        colk.clear();
        matB.getColumn(tCol).clear();
    }

    private static int sumAbsValues(SparseIntArray col) {
        int tot = 0;
        int i = 0;
        while (i < col.size()) {
            tot += Math.abs(col.valueAt(i));
            ++i;
        }
        return tot;
    }

    private static void test1b1(IntMatrixCol matC, IntMatrixCol matB, List<PpPm> pppms, Check11bResult chkResult) {
        int tCol = chkResult.col;
        while (chkResult.p.size() > 0) {
            int j = chkResult.p.keyAt(0);
            int chk = Math.abs(matC.get(chkResult.row, tCol));
            int chj = Math.abs(matC.get(chkResult.row, j));
            int gcd = MathTools.gcd(chk, chj);
            SparseBoolArray changed = InvariantCalculator.sumProdInto(chk /= gcd, matC.getColumn(j), chj /= gcd, matC.getColumn(tCol));
            int ind = 0;
            int inde = changed.size();
            while (ind < inde) {
                pppms.get(changed.keyAt(ind)).setValue(j, matC.getColumn(j).get(changed.keyAt(ind)));
                ++ind;
            }
            SparseIntArray coljb = matB.getColumn(j);
            InvariantCalculator.sumProdInto(chk, coljb, chj, matB.getColumn(tCol));
        }
        InvariantCalculator.clearColumn(chkResult.col, matC, matB, pppms);
    }

    private static void normalize(List<Integer> invariants) {
        int gcd = MathTools.gcd(invariants);
        if (gcd > 1) {
            int j = 0;
            while (j < invariants.size()) {
                int norm = invariants.get(j) / gcd;
                invariants.set(j, norm);
                ++j;
            }
        }
    }

    public static void normalizeWithSign(SparseIntArray col) {
        int gcd;
        boolean allneg = true;
        int i = 0;
        while (i < col.size()) {
            if (col.valueAt(i) > 0) {
                allneg = false;
                break;
            }
            ++i;
        }
        if (allneg) {
            i = 0;
            while (i < col.size()) {
                col.setValueAt(i, -col.valueAt(i));
                ++i;
            }
        }
        if ((gcd = MathTools.gcd(col)) > 1) {
            int j = 0;
            while (j < col.size()) {
                int norm = col.valueAt(j) / gcd;
                col.setValueAt(j, norm);
                ++j;
            }
        }
    }

    public static void normalize(SparseIntArray invariants) {
        int gcd = MathTools.gcd(invariants);
        if (gcd > 1) {
            int j = 0;
            while (j < invariants.size()) {
                int norm = invariants.valueAt(j) / gcd;
                invariants.setValueAt(j, norm);
                ++j;
            }
        }
    }

    private static Set<SparseIntArray> calcInvariantsFarkas(int[][] mat) {
        int rows = mat.length;
        if (mat.length == 0 || mat[0].length == 0) {
            return new HashSet<SparseIntArray>();
        }
        int cols = mat[0].length;
        int dcols = cols + rows;
        System.out.println("Initialize :");
        ArrayList d = new ArrayList();
        int i = 0;
        while (i < rows) {
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            d.add(i, arrayList);
            int n = 0;
            while (n < dcols) {
                if (n < cols) {
                    arrayList.add(n, mat[i][n]);
                } else {
                    arrayList.add(n, i != n - cols ? 0 : 1);
                }
                ++n;
            }
            ++i;
        }
        System.out.println("Phase 2 : rows :" + d.size() + " cols : " + ((List)d.get(0)).size());
        i = 0;
        while (i < cols) {
            int n;
            boolean bl = true;
            do {
                int n2;
                rows = d.size();
                n = 0;
                while (n < rows - 1) {
                    List z1 = (List)d.get(n);
                    int j2 = n + n2;
                    while (j2 < rows) {
                        List z2 = (List)d.get(j2);
                        if (Math.signum(((Integer)z1.get(i)).intValue()) * Math.signum(((Integer)z2.get(i)).intValue()) < 0.0f) {
                            int z1abs = Math.abs((Integer)z1.get(i));
                            int z2abs = Math.abs((Integer)z2.get(i));
                            ArrayList<Integer> z = new ArrayList<Integer>();
                            int k = 0;
                            while (k < dcols) {
                                int a = z2abs * (Integer)z1.get(k);
                                int b = z1abs * (Integer)z2.get(k);
                                z.add(k, a + b);
                                ++k;
                            }
                            int gcd = MathTools.gcd(z);
                            if (gcd != 1) {
                                int k2 = 0;
                                while (k2 < dcols) {
                                    z.set(k2, (Integer)z.get(k2) / gcd);
                                    ++k2;
                                }
                            }
                            d.add(z);
                        }
                        ++j2;
                    }
                    ++n;
                }
                n2 = rows;
                System.out.println("Phase 2 : rows :" + d.size() + " cols : " + ((List)d.get(0)).size());
            } while (rows < d.size());
            n = d.size() - 1;
            while (n >= 0) {
                if ((Integer)((List)d.get(n)).get(i) != 0) {
                    d.remove(n);
                }
                --n;
            }
            System.out.println("Phase 2 end of iteration : rows :" + d.size() + " cols : " + ((List)d.get(0)).size());
            ++i;
        }
        HashSet result = new HashSet();
        for (List list : d) {
            result.add(list.subList(cols, dcols));
        }
        HashSet<SparseIntArray> hashSet = new HashSet<SparseIntArray>(2 * result.size());
        for (List list : result) {
            hashSet.add(new SparseIntArray(list));
        }
        return hashSet;
    }

    public static Set<SparseIntArray> calcSInvariants(FlowMatrix pn, boolean onlyPositive) {
        return InvariantCalculator.calcSInvariants(pn, InvariantAlgorithm.PIPE, onlyPositive);
    }

    public static Set<SparseIntArray> calcSInvariants(FlowMatrix pn, InvariantAlgorithm algo, boolean onlyPositive) {
        switch (algo) {
            case FARKAS: {
                return InvariantCalculator.calcInvariantsFarkas(pn.getIncidenceMatrix().explicit());
            }
            case PIPE: {
                return InvariantCalculator.calcInvariantsPIPE(pn.getIncidenceMatrix().transpose(), onlyPositive);
            }
        }
        return InvariantCalculator.calcInvariantsFarkas(pn.getIncidenceMatrix().explicit());
    }

    public static Set<SparseIntArray> calcTInvariants(FlowMatrix pn, InvariantAlgorithm algo) {
        switch (algo) {
            case FARKAS: {
                return InvariantCalculator.calcInvariantsFarkas(pn.getIncidenceMatrix().explicit());
            }
            case PIPE: {
                return InvariantCalculator.calcInvariantsPIPE(pn.getIncidenceMatrix(), true);
            }
        }
        return InvariantCalculator.calcInvariantsFarkas(pn.getIncidenceMatrix().transpose().explicit());
    }

    private static class Check11bResult {
        public final int col;
        public final int row;
        public final SparseBoolArray p;

        public Check11bResult(int k, int row, SparseBoolArray pPlus) {
            this.col = k;
            this.row = row;
            this.p = pPlus;
        }
    }

    public static enum InvariantAlgorithm {
        FARKAS,
        PIPE;

    }

    private static class PpPm {
        public final int row;
        public final SparseBoolArray pPlus = new SparseBoolArray();
        public final SparseBoolArray pMinus = new SparseBoolArray();

        public PpPm(int row) {
            this.row = row;
        }

        public void setValue(int j, int val) {
            if (val == 0) {
                this.pMinus.clear(j);
                this.pPlus.clear(j);
            } else if (val < 0) {
                this.pMinus.set(j);
                this.pPlus.clear(j);
            } else {
                this.pMinus.clear(j);
                this.pPlus.set(j);
            }
        }

        public String toString() {
            return "PpPm [row=" + this.row + ", pPlus=" + String.valueOf(this.pPlus) + ", pMinus=" + String.valueOf(this.pMinus) + "]";
        }
    }
}

