/*
 * Decompiled with CFR 0.152.
 */
package uniol.apt.analysis.invariants;

import android.util.SparseIntArray;
import java.math.BigInteger;
import java.util.Collection;
import java.util.Iterator;

public class MathTools {
    private MathTools() {
    }

    public static BigInteger gcdBigInteger(Collection<BigInteger> set) {
        if (set.isEmpty()) {
            return BigInteger.ZERO;
        }
        Iterator<BigInteger> iter = set.iterator();
        BigInteger gcd = iter.next();
        while (iter.hasNext()) {
            BigInteger b = iter.next();
            BigInteger bigInteger = gcd = gcd.compareTo(b) < 0 ? b.gcd(gcd) : gcd.gcd(b);
        }
        return gcd;
    }

    public static int gcd(Collection<Integer> set) {
        if (set.isEmpty()) {
            return 0;
        }
        Iterator<Integer> iter = set.iterator();
        int gcd = iter.next();
        while (iter.hasNext()) {
            if ((gcd = MathTools.gcd(gcd, iter.next())) != 1) continue;
            return 1;
        }
        return gcd;
    }

    public static int gcd(SparseIntArray set) {
        if (set.size() == 0) {
            return 0;
        }
        int gcd = set.valueAt(0);
        int i = 1;
        while (i < set.size()) {
            if ((gcd = MathTools.gcd(gcd, set.valueAt(i))) == 1) {
                return 1;
            }
            ++i;
        }
        return gcd;
    }

    public static int gcd(int a, int b) {
        if (a < b) {
            return BigInteger.valueOf(b).gcd(BigInteger.valueOf(a)).intValueExact();
        }
        return BigInteger.valueOf(a).gcd(BigInteger.valueOf(b)).intValueExact();
    }

    public static BigInteger lcm(BigInteger a, BigInteger b) {
        return a.divide(a.gcd(b)).multiply(b).abs();
    }

    public static int lcm(int a, int b) {
        return MathTools.bigIntToInt(MathTools.lcm(BigInteger.valueOf(a), BigInteger.valueOf(b)));
    }

    private static int bigIntToInt(BigInteger value) {
        if (value.compareTo(BigInteger.valueOf(Integer.MAX_VALUE)) > 0 || value.compareTo(BigInteger.valueOf(Integer.MIN_VALUE)) < 0) {
            throw new ArithmeticException("Cannot represent value as int: " + String.valueOf(value));
        }
        return value.intValue();
    }

    public static int mod(int a, int b) {
        return BigInteger.valueOf(a).mod(BigInteger.valueOf(b)).intValue();
    }
}

