/*
 * Decompiled with CFR 0.152.
 */
package uniol.apt.analysis.invariants;

import fr.lip6.move.gal.util.Pair;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class Matrix
implements Iterable<List<Integer>> {
    private int iRows;
    private int iCols;
    private final List<List<Integer>> lRows;

    public static Matrix identity(int m, int n) {
        Matrix result = new Matrix(m, n);
        int i = 0;
        while (i < m) {
            List<Integer> row = result.lRows.get(i);
            if (i < n) {
                row.set(i, 1);
            }
            ++i;
        }
        return result;
    }

    public Matrix(int m, int n) {
        this.iRows = m;
        this.iCols = n;
        this.lRows = new ArrayList<List<Integer>>(this.iRows);
        int i = 0;
        while (i < this.iRows) {
            ArrayList<Integer> col = new ArrayList<Integer>(this.iCols);
            int j = 0;
            while (j < this.iCols) {
                col.add(0);
                ++j;
            }
            this.lRows.add(col);
            ++i;
        }
    }

    public Matrix(int[][] src) {
        this.iRows = src.length;
        this.iCols = src[0].length;
        this.lRows = new ArrayList<List<Integer>>(this.iRows);
        int i = 0;
        while (i < this.iRows) {
            int[] row = src[i];
            ArrayList<Integer> vRow = new ArrayList<Integer>(this.iCols);
            int j = 0;
            while (j < this.iCols) {
                vRow.add(row[j]);
                ++j;
            }
            this.lRows.add(vRow);
            ++i;
        }
    }

    public int getRowCount() {
        return this.iRows;
    }

    public int getColumnCount() {
        return this.iCols;
    }

    public List<Integer> getRow(int i) {
        return this.lRows.get(i);
    }

    public List<Integer> getColumn(int i) {
        ArrayList<Integer> result = new ArrayList<Integer>(this.iCols);
        for (List<Integer> row : this.lRows) {
            result.add(row.get(i));
        }
        return result;
    }

    public Pair<Integer, List<Integer>> getNoneZeroRow() {
        for (List<Integer> row : this.lRows) {
            int i = 0;
            while (i < row.size()) {
                if (row.get(i) != 0) {
                    return new Pair<Integer, List<Integer>>(i, row);
                }
                ++i;
            }
        }
        return null;
    }

    public Pair<Integer, List<Integer>> getRowWithNegativeElement() {
        int min = -1;
        int minRow = -1;
        int i = 0;
        while (i < this.lRows.size()) {
            List<Integer> row = this.lRows.get(i);
            boolean hasNeg = false;
            int sz = 0;
            for (Integer val : row) {
                if (val < 0) {
                    hasNeg = true;
                    ++sz;
                    continue;
                }
                if (val <= 0) continue;
                ++sz;
            }
            if (hasNeg && (min == -1 || minRow > sz)) {
                min = i;
                minRow = sz;
            }
            ++i;
        }
        if (min == -1) {
            return null;
        }
        return new Pair<Integer, List<Integer>>(min, this.lRows.get(min));
    }

    public void deleteColumn(int j) {
        for (List<Integer> row : this.lRows) {
            row.remove(j);
        }
        --this.iCols;
    }

    public void appendColumn(List<Integer> column) {
        assert (this.iRows == column.size());
        int i = 0;
        while (i < this.iRows) {
            this.lRows.get(i).add(column.get(i));
            ++i;
        }
        ++this.iCols;
    }

    public boolean isZero() {
        for (List<Integer> row : this.lRows) {
            for (Integer i : row) {
                if (i == 0) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public Iterator<List<Integer>> iterator() {
        return this.lRows.iterator();
    }

    public String toString() {
        return "Matrix{lRows=" + String.valueOf(this.lRows) + "}";
    }
}

